% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.als.R
\name{power.bias}
\alias{power.bias}
\title{Simulate and plot detection power of bias in allele ratios}
\usage{
power.bias(
  Dlist = c(2, 4, 8, 16),
  sam = 100,
  intensity = 0.005,
  nsims = 1000,
  p = 0.5,
  plot = TRUE
)
}
\arguments{
\item{Dlist}{numerical. vector of depths values to be tested}

\item{sam}{numerical. number of samples}

\item{intensity}{numerical. frequency of bias}

\item{nsims}{numerical. number of simulations to be done for each sample}

\item{p}{numerical. expected allele ratio (0.5 for data with known
sequencing biases)}

\item{plot}{logical. plot the output}
}
\value{
Returns a list of detection probability values for the given range of
samples and depth
}
\description{
This function simulates 95\% confidence level Z-score based detection power
of allele biases for a given number of samples and a range of depths
}
\author{
Pascal Milesi, Piyal Karunarathne
}
