% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameter.R
\name{get_parameter}
\alias{get_parameter}
\title{Get parameter from (reversed) JST results}
\usage{
get_parameter(x, parameter = NULL)
}
\arguments{
\item{x}{A JST_reversed.result or JST.result object}

\item{parameter}{Character. The parameter to be tidied and returned. 
Note that no default is set.}
}
\value{
A data.frame.
}
\description{
Take the results object for the selected parameter
and return a data.frame which is similar to tidy standards.
}
\examples{
data <- quanteda::dfm(quanteda::data_corpus_irishbudget2010)
model <- jst(data, paradigm(), numTopics = 5, numIters = 50)

phi <- get_parameter(model, 'phi')

}
