% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy-mf.R
\name{degree_mf}
\alias{degree_mf}
\title{Define generic calculation of fuzzy membership degrees}
\usage{
degree_mf(shape, input)
}
\arguments{
\item{shape}{is the object (\code{trapezoid_mf}, \code{triangle_mf} and \code{fuzzy_partitions}) to dispatch to.}

\item{input}{is the value to be assess.}
}
\value{
the membership degree for a given input values.
}
\description{
It is a generic function in charge of computing fuzzy membership degrees. Namely, it identifies the specific
membership function to consider and run the related method for computing the membership degree for a given
input value. It takes as input an object (\code{trapezoid_mf}, \code{triangle_mf} and \code{fuzzy_partitions}) and the related input values
}
\examples{

w <- degree_mf(triangle_mf(450,450,550),450)

w <- degree_mf(fuzzy_partitions(triangle_mf(450,450,550),
                                triangle_mf(450,550,600),
                                trapezoid_mf(550,600,800,1000),
                                triangle_mf(800,1000,1300),
                                trapezoid_mf(1000,1300,1500,1500)),450)
}

