% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi.temperature.R
\name{epi.temperature}
\alias{epi.temperature}
\title{Get volumetrically averaged epilimnion temp}
\usage{
epi.temperature(wtr, depths, bthA, bthD)
}
\arguments{
\item{wtr}{a numeric vector of water temperature in degrees C.}

\item{depths}{a numeric vector corresponding to the depths (in m) of the wtr measurements}

\item{bthA}{a numeric vector of cross sectional areas (m^2) corresponding to bthD depths}

\item{bthD}{a numeric vector of depths (m) which correspond to areal measures in bthA}
}
\description{
Calculates volumetrically weighted average epilimnetic temperature using
the supplied water temperature timeseries. If the lake is not stratified, the bottom 
of the epilimnion is calculated as the full depth of the lake.
}
\seealso{
\code{\link{hypo.temperature}}, \code{\link{whole.lake.temperature}}
}

