% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espa_product.R
\name{espa_products}
\alias{espa_products}
\title{Check Available Products for given Product-IDs}
\usage{
espa_products(input_ids, host = "https://espa.cr.usgs.gov/api/v1/",
  username = NULL, password = NULL)
}
\arguments{
\item{input_ids}{vector of product ids for which available products are needed}

\item{host}{the api call host. Default set to espa v1 web api}

\item{username}{default NULL, which fetches the username from the global environment. If defined otherwise, will run the api with the provided details}

\item{password}{default NULL, which fetches the password from the global environment. If defined otherwise, will run the api with the provided details}
}
\value{
a list :
\item{master}{dataframe with product ids as one of the columns and a column for each product with 0 (not available) and 1 (available) values.}
\item{no_product}{a vector of product_ids which are incorrect}
\item{sample_message}{sample response from the espa-api}
Returns NULL if the espa credentials are not  incorrect or the api is unresponsive
}
\description{
For a set of product IDs, check which products (like, sr, toa, spectral indices) are available to download
}
\examples{
\dontrun{
# input the credentials, if not defined earlier
espa_creds("your_espaname", "secret_password")

# saving the product ids as a vector
product_ids = c("LC08_L1TP_148047_20180202_20180220_01_T1",
              "LC08_L1TP_134040_20180115_20180120_01_T1",
               "invalid_id")

# running function to get the available products
## does not return anything as credentials wrong
result = espa_products(input_ids = product_ids)}
}
