% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ForestCAS.R
\name{ForestCAS}
\alias{ForestCAS}
\title{Deriving the ground-projected canopy area of individual trees using LiDAR-derived derived Canopy Height Model (CHM)}
\usage{
ForestCAS(chm, loc, maxcrown, exclusion)
}
\arguments{
\item{chm}{A LiDAR-derived Canopy Height Model (CHM) RasterLayer or SpatialGridDataFrame file.}

\item{loc}{A matrix or dataframe with three columns (tree xy coordinates and height).}

\item{maxcrown}{A single value of the maximum individual tree crown radius expected. Default 10.0 m.}

\item{exclusion}{A single value from 0 to 1 that represents the \out{\%} of pixel exclusion. E.g. a value of 0.5 will exclude all of the pixels for a single tree that has a height value of less than 50\out{\%} of the maximum height from the same tree. Default value is 0.3.}
}
\value{
Returns a list that contains the individual tree canopy boundary polygons and the 4-column matrix with the tree xy coordinates, heights and ground-projected canopy area (with units of square meters).
}
\description{
Compute and export the ground-projected areas of individual tree canopies detected within the LiDAR-derived Canopy Height Model (CHM)
}
\examples{
\dontrun{

# Import the LiDAR-derived CHM file
data(chm) # or set a CHM. e.g. chm<-raster("CHM_stand.asc")

# Set the loc parameter
sCHM<-CHMsmoothing(chm, filter="mean", ws=5) # smoothing CHM
loc<-FindTreesCHM(sCHM, fws=5, minht=8)      # or import a tree list

# Set the maxcrown parameter
maxcrown=10.0

# Set the exclusion parameter
exclusion=0.3 # 30

# Compute individual tree detection canopy area
canopy<-ForestCAS(chm, loc, maxcrown, exclusion)

#==================================================================================#
# Retrieving the boundary for individual tree detection and canopy area calculation
#==================================================================================#
boundaryTrees<-canopy[[1]]
# Plotting the individual tree canopy boundary over the CHM
plot(chm, main="LiDAR-derived CHM")
plot(boundaryTrees, add=T, border='red', bg='transparent') # adding tree canopy boundary

#============================================================================#
# Retrieving the list of individual trees detected for canopy area calculation
#============================================================================#
canopyList<-canopy[[2]] # list of ground-projected areas of individual tree canopies
summary(canopyList)     # summary

# Spatial location of the trees
library(sp)
XY<-SpatialPoints(canopyList[,1:2])    # Spatial points
plot(XY, col="black", add=T, pch="*")  # adding tree location to the plot
}
}
\author{
Carlos Alberto Silva
}

