% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_graphics.R
\name{MEAheatmap}
\alias{MEAheatmap}
\title{Plot a heatmap of dyadic cross-correlations}
\usage{
MEAheatmap(mea, legendSteps = 10, rescale = FALSE,
  colors = c("#F5FBFF", "#86E89E", "#FFF83F", "#E8A022", "#FF3700"),
  bias = 1)
}
\arguments{
\item{mea}{an object of class \code{MEA} (see function \code{\link{readMEA}}).}

\item{legendSteps}{integer. the number of levels used for the color-coding of the legend.}

\item{rescale}{logical. If True, the color range will represent the minimum and maximum of the data. Otherwise the theoretical correlation range -1 to 1.}

\item{colors, bias}{optional arguments passed to \code{\link[grDevices]{colorRampPalette}}.}
}
\description{
Graphical representation of the lagged cross-correlations in time. Provides an intuitive description of synchronization dynamics.
}
\details{
The cross-correlation values are rescaled to be in a range from 0 to 1 before plotting.
}
