\name{Eq.Ox.conc}
\alias{Eq.Ox.conc}

\title{
Equilibrium Concentration of Dissolved Oxygen in Water
}
\description{
Determines equilibrium dissolved oxygen concentration in water based on pressure and temperature. An estimate for barometric pressure can be generated by supplying the temperature and elevation (calculation by \code{Barom.Press()})
}
\usage{
Eq.Ox.conc(temp.C, elevation.m = NULL, 
bar.press = NULL, bar.units = "mmHg", 
out.DO.meas = "mg/L", 
salinity = 0, salinity.units = "pp.thou")
}

\arguments{
  \item{temp.C}{
    Water temperature in degrees C
}
  \item{elevation.m}{
    Elevation in meters. Default = \code{NULL}. Must be \code{NULL} if \code{bar.press} takes a value.
}
  \item{bar.press}{
    Barometric pressure. Default = \code{NULL}. Must be \code{NULL} if \code{elevation.m} takes a value.
}
  \item{bar.units}{
    Units of barometric pressure for value supplied in bar.press. Must be \code{NULL}, \code{"atm"}, \code{"kpa"}, or\code{"mmHg"}.
}
  \item{out.DO.meas}{
    Units of dissolved oxygen concentration 
}
  \item{salinity}{
    Salinity, either reported in parts per thousand (\code{"pp.thou"}) or microsiemens/cm (\code{"us"}) 
}
  \item{salinity.units}{
    Salinity units, must be \code{"pp.thou"} or \code{"us"}. 
}
}
\value{
Returns object of class numberic of full equilibrium dissolved oxygen concentration.
}
\references{
Benson, B.B., and Daniel Krause, Jr (1980). The concentration and isotopic fractionation of gases dissolved in freshwater in equilibrium with the atmosphere. 1. Oxygen: Limnology and Oceanography, vol. 25, no. 4, p. 662-671. \doi{10.4319/lo.1980.25.4.0662}.

Gnaiger, Erich, and Hellmuth Forstner, eds. Polarographic oxygen sensors: Aquatic and physiological applications. Springer Science & Business Media, 2012. \doi{10.1007/978-3-642-81863-9}.

Mechtly, E. A., 1973: The International System of Units, Physical Constants and Conversion Factors. NASA SP-7012, Second Revision, National Aeronautics and Space Administration, Washington, D.C. \url{https://ntrs.nasa.gov/archive/nasa/casi.ntrs.nasa.gov/19730018242.pdf}.

U.S. Geological Survey (2011). Change to solubility equations for oxygen in water: Office of Water Quality Technical Memorandum 2011.03, accessed July 15, 2011, at \url{http://water.usgs.gov/admin/memo/QW/qw11.03.pdf}.

}
\author{
Tyler L. Moulton
}

\seealso{
 \code{\link{DO.saturation}}
 \code{\link{DO.unit.convert}}
 \code{\link{Barom.Press}}
}
\examples{
eqO2.1 <- Eq.Ox.conc(temp.C = 20, elevation.m = 1000, bar.units = NULL)

eqO2.2 <- Eq.Ox.conc(temp.C = 20,
bar.press = 674.1, bar.units = "mmHg")

eqO2.1
eqO2.2

}
