% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Data.r
\name{MVP.Data.PC}
\alias{MVP.Data.PC}
\title{Principal component analysis}
\usage{
MVP.Data.PC(filePC = TRUE, mvp_prefix = "mvp", K = NULL,
  out = NULL, pcs.keep = 5, priority = "speed", sep = "\\t",
  cpus = 1, verbose = TRUE)
}
\arguments{
\item{filePC}{Principal components, n*npc, n is sample size, npc is number of top columns of principal components}

\item{mvp_prefix}{Prefix for mvp format files}

\item{K}{Kinship matrix}

\item{out}{prefix of output file name}

\item{pcs.keep}{how many PCs to keep}

\item{priority}{speed or memory}

\item{sep}{seperator for PC file.}

\item{cpus}{the number of cpu}

\item{verbose}{whether to print detail.}
}
\value{
Output file:
<out>.pc.bin
<out>.pc.desc
}
\description{
Principal component analysis
}
\examples{
geno <- file.path(system.file("extdata", "06_mvp-impute", package = "rMVP"), "mvp.imp")

MVP.Data.PC(TRUE, mvp_prefix=geno, out=file.path(tempdir(), "rMVP.test"))

}
