% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.GLM.r
\name{MVP.GLM}
\alias{MVP.GLM}
\title{To perform GWAS with GLM and MLM model and get the P value of SNPs}
\usage{
MVP.GLM(phe, geno, CV = NULL, cpu = 1, verbose = TRUE)
}
\arguments{
\item{phe}{phenotype, n * 2 matrix}

\item{geno}{Genotype in numeric format, pure 0, 1, 2 matrix; m * n, m is marker size, n is population size}

\item{CV}{Covariance, design matrix(n * x) for the fixed effects}

\item{cpu}{number of cpus used for parallel computation}

\item{verbose}{whether to print detail.}
}
\value{
m * 2 matrix, the first column is the SNP effect, the second column is the P values
}
\description{
Build date: Aug 30, 2016
Last update: May 25, 2017
}
\examples{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
idx <- !is.na(phenotype[, 2])
phenotype <- phenotype[idx, ]
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
genotype <- deepcopy(genotype, cols=idx)
print(dim(genotype))

glm <- MVP.GLM(phe=phenotype, geno=genotype)
str(glm)
}
\author{
Lilin Yin and Xiaolei Liu
}
