% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPACI.R
\name{readCornealTopography}
\alias{readCornealTopography}
\title{Read a Placido disk corneal topography file}
\usage{
readCornealTopography(filepath)
}
\arguments{
\item{filepath}{A file path to a corneal topography file exported by a Placido disk corneal topographer.}
}
\value{
A dataset containing the read corneal topography.
}
\description{
Read corneal topography files as exported by Placido disk corneal topographer.
A corneal topographer is an ophthalmic clinical device that obtains measurements
in the cornea (the anterior part of the eye). A Placido disk corneal topographer
makes use of the Placido disk (see references), which produce a circular pattern of
measurement nodes.
This function assumes a file structure of 24 rings * 256 angles per ring,
which is the typical distribution of commercial Placido disk topographers.
}
\examples{
datasetN = readCornealTopography(system.file("extdata","N01.txt", package="rPACI"))
datasetK = readCornealTopography(system.file("extdata","K04.txt", package="rPACI"))
}
\references{
Rowsey, J. J., Reynolds, A. E., & Brown, R. (1981). Corneal topography: corneascope. Archives of Ophthalmology, 99(6), 1093-1100

Rand, R. H., Howland, H. C., & Applegate, R. A. (1997). Keratometer and Its Implications for Recovery of Corneal Topography. Optometry and vision science, 74(11).
}
