% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt.R
\name{pt.legendreSynth}
\alias{pt.legendreSynth}
\title{pt.legendreSynth}
\usage{
pt.legendreSynth(c, npoints = 1000)
}
\arguments{
\item{c}{Vector of Legendre polynomials coefficients}

\item{npoints}{Number of points of PitchTier interpolation}
}
\value{
Vector of values of synthetized contour
}
\description{
Synthetize the contour from vector of Legendre polynomials \code{c} in \code{npoints} equidistant points
}
\examples{
pt <- pt.sample()
pt <- pt.Hz2ST(pt)
pt <- pt.cut(pt, tStart = 3)  # cut PitchTier from t = 3 sec and preserve time
c <- pt.legendre(pt)
print(c)
leg <- pt.legendreSynth(c)
ptLeg <- pt
ptLeg$t <- seq(ptLeg$tmin, ptLeg$tmax, length.out = length(leg))
ptLeg$f <- leg
\dontrun{
plot(pt$t, pt$f, xlab = "Time (sec)", ylab = "F0 (ST re 100 Hz)")
lines(ptLeg$t, ptLeg$f, col = "blue")
}
}
\seealso{
\code{\link{pt.legendre}}, \code{\link{pt.legendreDemo}}, \code{\link{pt.read}}, \code{\link{pt.plot}}, \code{\link{pt.Hz2ST}}, \code{\link{pt.interpolate}}
}
