% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/it.R
\name{it.legendreSynth}
\alias{it.legendreSynth}
\title{it.legendreSynth}
\usage{
it.legendreSynth(c, npoints = 1000)
}
\arguments{
\item{c}{Vector of Legendre polynomials coefficients}

\item{npoints}{Number of points of IntensityTier interpolation}
}
\value{
Vector of values of synthetized contour
}
\description{
Synthetize the contour from vector of Legendre polynomials \code{c} in \code{npoints} equidistant points
}
\examples{
it <- it.sample()
it <- it.cut(it, tStart = 0.2, tEnd = 0.4)  # cut IntensityTier and preserve time
c <- it.legendre(it)
print(c)
leg <- it.legendreSynth(c)
itLeg <- it
itLeg$t <- seq(itLeg$tmin, itLeg$tmax, length.out = length(leg))
itLeg$i <- leg
\dontrun{
plot(it$t, it$i, xlab = "Time (sec)", ylab = "Intensity (dB)")
lines(itLeg$t, itLeg$i, col = "blue")
}
}
\seealso{
\code{\link{it.legendre}}, \code{\link{it.legendreDemo}}, \code{\link{it.read}}, \code{\link{it.plot}}, \code{\link{it.interpolate}}
}
