% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-pref-macros.r
\name{base_pref_macros}
\alias{around}
\alias{base_pref_macros}
\alias{between}
\alias{layered}
\alias{pos}
\title{Useful Base Preference Macros}
\usage{
around(expr, center, df = NULL)

between(expr, left, right, df = NULL)

pos(expr, pos_value, df = NULL)

layered(expr, ..., df = NULL)
}
\arguments{
\item{expr}{A numerical expression (for \code{around} and \code{between})
or an arbitrary expression (for \code{pos} and \code{layered}).
The objective are those tuples where \code{expr} evaluates to a value within the preferred interval, layer, etc. 
Regarding attributes, functions and variables, the same requirements as for \code{\link{base_pref}} apply.}

\item{center}{Preferred numerical value for \code{around}.}

\item{df}{(optional) Data frame for partial evaluation and association of preference and data set.
See \code{\link{base_pref}} for details.}

\item{left}{Lower limit (numerical) of the preferred interval for \code{between}.}

\item{right}{Upper limit (numerical) of the preferred interval for \code{between}.}

\item{pos_value}{A vector containing the preferred values for a \code{pos} preference.
It has to be of the same type (numeric, logical, character, ...) as \code{expr}.}

\item{...}{Layers (sets) for a \code{layered} preference. Each parameter corresponds to a layer 
and the first one characterizes the most preferred values.}
}
\description{
In addition to the base preferences, 
rPref offers some macros to define preferences where a given interval or point is preferred.
}
\section{Definition of the Preference Macros}{


\describe{
  \item{\code{between(expr, left, right)}}{Those tuples are preferred where \code{expr} evaluates
    to a value between \code{left} and \code{right}.
    For values not in this interval, the values nearest to the interval are preferred.}
  \item{\code{around(expr, center)}}{Same as \code{between(expr, center, center)}.}
  \item{\code{pos(expr, pos_value)}}{Those tuples are preferred, where \code{expr} evaluates 
    to a value which is contained in \code{pos_value}.}
  \item{\code{layered(expr, layer1, layer2, ..., layerN)}}{For the most preferred tuples \code{expr}
    must evaluate to a value in \code{layer1}. 
    The second-best tuples are those where \code{expr} evaluates to a value in \code{layer2} and so forth. 
     Values occurring in none of the layers are considered worse than those in \code{layerN}.
     Technically, this is realized by a prioritization chain (lexicographical order)
     of \code{\link{true}} preferences.}
}

Note that only the argument \code{expr} may contain columns from the data frame, 
all other variables must evaluate to explicit values. 
For example \code{around(mpg, mean(mpg))} is not allowed. In this case, one can use 
\code{around(mpg, mean(mtcars$mpg))} instead. Or alternatively, without using the base preference macros, 
\code{low(abs(mpg - mean(mpg)))} does the same. There, the actual mean value of \code{mpg} is calculated 
just when the preference selection via \code{psel} is called.
}
\examples{
# search for cars where mpg is near to 25
psel(mtcars, around(mpg, 25))

# cyl = 2 and cyl = 4 are equally good, cyl = 6 is worse
psel(mtcars, layered(cyl, c(2, 4), 6))
}

