% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSARP.r
\name{searchstatus}
\alias{searchstatus}
\title{\code{searchstatus()} - provides summary graphs of search.}
\usage{
searchstatus(filout = "SearchOut.csv", directory = "Searches",
  STitle = "")
}
\arguments{
\item{filout}{- string variable. Name of the output csv file generated by the searchme function. This file usually is named SearchOut.csv but can be changed from the default
by the user.  If the user renames the output file from searchme, the same name must be used here as this file is located in the working directory and
is used as the source of input values.}

\item{directory}{- string variable.  Name of the directory created and used by the searchme function to store output charts and files under the R working directory. This directory is expected to exist at the time the function is run.}

\item{STitle}{- string representing the name of the search for use as a title on the graphic output}
}
\value{
searchstatus returns a pdf file that contains 2 or 3 pages of graphs summarizing a search.
}
\description{
\code{searchstatus()} - this function called by searchme to produce summary graphs of search for management.
}
\details{
\code{searchstatus()} summarizes a search in a series of graphs which display search plans. The graphs display all sectors in order of sector ladder importance or in order of POS (probability of success) expected along with other metrics critical to search managment.  The leading chart is a barchart which shows the available POS,the POS already "harvested", and the POS expected in this planning cycle.
Pareto charts then summarize the remainting metrics which include POS expected, POS remaining, Searchers required, duration hours planned, sectors with the highest potential to go faster with more manpower, sectors with the best potential to return POS with manpower added, man hours required, and manhours per POS. An additional page summarizes the sectors that have been set aside as "complete" and where no further search effort is planned. This function stores the charts in the R working directory or a subdirectory if one is called out through the \strong{directory} parameter
}
\examples{
\dontrun{searchstatus(STitle="Alternate Search Plan B")}
}
\author{
John F. Hutcheson
}

