% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDI.R
\name{SDIcomputer}
\alias{SDIcomputer}
\title{SDIcomputer() is a helper function to compute given SDI variant for the given graph object.
Not intended for explicit use. Called automatically by the `SDI()` function.}
\usage{
SDIcomputer(g, level, weight.use, directionality, return.value = FALSE)
}
\arguments{
\item{g}{An igraph object.}

\item{level}{The level to calculate the SDI. 'network' or 'vertex'.}

\item{weight.use}{'weighted' or 'unweighted'.}

\item{directionality}{'undirected', 'in', 'out', or 'all'.}

\item{return.value}{Logical. If TRUE, return the computed SDI value instead of modifying the graph object.}
}
\value{
If return.value is TRUE, returns the computed SDI value. Otherwise, returns the modified graph object.
}
\description{
SDIcomputer() is a helper function to compute given SDI variant for the given graph object.
Not intended for explicit use. Called automatically by the `SDI()` function.
}
\examples{
TMgraph <- igraph::graph_from_data_frame(TurkiyeMigration.flows,
      directed=TRUE, TurkiyeMigration.nodes)
SDIcomputer(TMgraph,"vertex","weighted","in")
}
