% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{get.inital.values.rSPDE}
\alias{get.inital.values.rSPDE}
\title{Initial values for log-likelihood optimization in rSPDE models
with a latent stationary Gaussian Matern model}
\usage{
get.inital.values.rSPDE(
  mesh = NULL,
  mesh.range = NULL,
  dim = NULL,
  include.nu = TRUE,
  log.scale = TRUE,
  include.tau = FALSE,
  nu_upper_bound = NULL
)
}
\arguments{
\item{mesh}{An in INLA mesh}

\item{mesh.range}{The range of the mesh.}

\item{dim}{The dimension of the domain.}

\item{include.nu}{Should we also provide an initial guess for nu?}

\item{log.scale}{Should the results be provided in log scale?}

\item{include.tau}{Should tau be returned instead of sigma?}

\item{nu_upper_bound}{Should an upper bound for nu be considered?}
}
\value{
A vector of the form (theta_1,theta_2,theta_3) or where
theta_1 is the initial guess for tau, theta_2 is the initial guess for kappa
and theta_3 is the initial guess for nu.
}
\description{
Auxiliar function to obtain domain-based initial values for
log-likelihood optimization in rSPDE models
with a latent stationary Gaussian Matern model
}
