% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{create_train_test_indices}
\alias{create_train_test_indices}
\title{Create train and test splits to be used in the \code{cross_validation} function}
\usage{
create_train_test_indices(
  data,
  cv_type = c("k-fold", "loo", "lpo"),
  k = 5,
  percentage = 20,
  number_folds = 10
)
}
\arguments{
\item{data}{A \code{list}, \code{data.frame}, \code{SpatialPointsDataFrame} or \code{metric_graph_data} objects.}

\item{cv_type}{The type of the folding to be carried out. The options are \code{k-fold} for \code{k}-fold cross-validation, in which case the parameter \code{k} should be provided,
\code{loo}, for leave-one-out and \code{lpo} for leave-percentage-out, in this case, the parameter \code{percentage} should be given, and also the \code{number_folds}
with the number of folds to be done. The default is \code{k-fold}.}

\item{k}{The number of folds to be used in \code{k}-fold cross-validation. Will only be used if \code{cv_type} is \code{k-fold}.}

\item{percentage}{The percentage (from 1 to 99) of the data to be used to train the model. Will only be used if \code{cv_type} is \code{lpo}.}

\item{number_folds}{Number of folds to be done if \code{cv_type} is \code{lpo}.}
}
\value{
A list with two elements, \code{train} containing the training indices and \code{test} containing indices.
}
\description{
Train and test splits
}
