/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBeanProperty;
import org.python.core.PyException;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyReflectedConstructor;
import org.python.core.PyReflectedField;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyType;
import org.python.core.util.StringUtil;
import org.python.expose.ExposeAsSuperclass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyJavaType
extends PyType
implements ExposeAsSuperclass {
    private static final Class<?>[] OO = new Class[]{PyObject.class, PyObject.class};

    public PyJavaType() {
        super(TYPE == null ? PyJavaType.fromClass(PyType.class) : TYPE);
    }

    @Override
    protected void fillDict() {
        Field[] fields;
        Method[] methods;
        this.dict = new PyStringMap();
        HashMap<String, Object> propnames = new HashMap<String, Object>();
        Class base = this.underlying_class.getSuperclass();
        for (Method meth : methods = this.underlying_class.getMethods()) {
            Class<?> declaring = meth.getDeclaringClass();
            if (base != null && (declaring == base || !base.isAssignableFrom(declaring) || PyJavaType.ignore(meth))) continue;
            String methname = meth.getName();
            String nmethname = PyJavaType.normalize_name(methname);
            PyReflectedFunction reflfunc = (PyReflectedFunction)this.dict.__finditem__(nmethname);
            boolean added = false;
            if (reflfunc == null) {
                this.dict.__setitem__(nmethname, (PyObject)new PyReflectedFunction(meth));
                added = true;
            } else {
                reflfunc.addMethod(meth);
                added = true;
            }
            if (!added || Modifier.isStatic(meth.getModifiers())) continue;
            int n = meth.getParameterTypes().length;
            if (methname.startsWith("get") && n == 0) {
                propnames.put(methname.substring(3), "getter");
                continue;
            }
            if (methname.startsWith("is") && n == 0 && meth.getReturnType() == Boolean.TYPE) {
                propnames.put(methname.substring(2), "getter");
                continue;
            }
            if (!methname.startsWith("set") || n != 1) continue;
            propnames.put(methname.substring(3), meth);
        }
        for (Method meth : methods) {
            String nmethname = PyJavaType.normalize_name(meth.getName());
            PyReflectedFunction reflfunc = (PyReflectedFunction)this.dict.__finditem__(nmethname);
            if (reflfunc == null) continue;
            reflfunc.addMethod(meth);
        }
        for (Field field : fields = this.underlying_class.getFields()) {
            String fname;
            PyObject memb;
            Class<?> declaring = field.getDeclaringClass();
            if (declaring == base || !base.isAssignableFrom(declaring)) continue;
            String fldname = field.getName();
            int fldmods = field.getModifiers();
            Class<?> fldtype = field.getType();
            if (Modifier.isStatic(fldmods) && fldname.startsWith("__doc__") && fldname.length() > 7 && fldtype == PyString.class && (memb = this.dict.__finditem__(fname = fldname.substring(7).intern())) != null && memb instanceof PyReflectedFunction) {
                PyString doc = null;
                try {
                    doc = (PyString)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw PyJavaType.error(e);
                }
                ((PyReflectedFunction)memb).__doc__ = doc;
            }
            this.dict.__setitem__(PyJavaType.normalize_name(fldname), (PyObject)new PyReflectedField(field));
        }
        for (String propname : propnames.keySet()) {
            String npropname = PyJavaType.normalize_name(StringUtil.decapitalize(propname));
            PyObject prev = this.dict.__finditem__(npropname);
            if (prev != null && prev instanceof PyReflectedFunction) continue;
            Method getter = null;
            Method setter = null;
            Class<?> proptype = null;
            getter = PyJavaType.get_non_static_method(this.underlying_class, "get" + propname, new Class[0]);
            if (getter == null) {
                getter = PyJavaType.get_non_static_method(this.underlying_class, "is" + propname, new Class[0]);
            }
            if (getter != null) {
                proptype = getter.getReturnType();
                setter = PyJavaType.get_non_static_method(this.underlying_class, "set" + propname, proptype);
            } else {
                Object o = propnames.get(propname);
                if (o instanceof Method) {
                    setter = (Method)o;
                    proptype = setter.getParameterTypes()[0];
                }
            }
            if (setter == null && getter == null) continue;
            this.dict.__setitem__(npropname, (PyObject)new PyBeanProperty(npropname, proptype, getter, setter));
        }
        Constructor<?>[] ctrs = this.underlying_class.getConstructors();
        if (ctrs.length != 0) {
            final PyReflectedConstructor reflctr = new PyReflectedConstructor("_new_impl");
            for (Constructor<?> ctr : ctrs) {
                reflctr.addConstructor(ctr);
            }
            if (PyObject.class.isAssignableFrom(this.underlying_class)) {
                PyNewWrapper new_ = new PyNewWrapper(this.underlying_class, "__new__", -1, -1){

                    public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                        return reflctr.make(args, keywords);
                    }
                };
                this.dict.__setitem__("__new__", (PyObject)new_);
            } else {
                this.dict.__setitem__("__init__", (PyObject)reflctr);
            }
        }
        if (ClassDictInit.class.isAssignableFrom(this.underlying_class) && this.underlying_class != ClassDictInit.class) {
            try {
                Method m = this.underlying_class.getMethod("classDictInit", PyObject.class);
                m.invoke(null, this.dict);
            }
            catch (Exception exc) {
                throw PyJavaType.error(exc);
            }
        }
        if (base != Object.class) {
            this.has_set = PyJavaType.get_descr_method(this.underlying_class, "__set__", OO) != null || PyJavaType.get_descr_method(this.underlying_class, "_doset", OO) != null;
            this.has_delete = PyJavaType.get_descr_method(this.underlying_class, "__delete__", PyObject.class) != null || PyJavaType.get_descr_method(this.underlying_class, "_dodel", PyObject.class) != null;
        }
    }

    private static String normalize_name(String name) {
        if (name.endsWith("$")) {
            name = name.substring(0, name.length() - 1);
        }
        return name.intern();
    }

    private static Method get_non_static_method(Class<?> c, String name, Class<?> ... parmtypes) {
        try {
            Method meth = c.getMethod(name, parmtypes);
            if (!Modifier.isStatic(meth.getModifiers())) {
                return meth;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Method get_descr_method(Class<?> c, String name, Class<?> ... parmtypes) {
        Method meth = PyJavaType.get_non_static_method(c, name, parmtypes);
        if (meth != null && meth.getDeclaringClass() != PyObject.class) {
            return meth;
        }
        return null;
    }

    private static boolean ignore(Method meth) {
        Class<?>[] exceptions2;
        for (Class<?> exception : exceptions2 = meth.getExceptionTypes()) {
            if (exception != PyIgnoreMethodTag.class) continue;
            return true;
        }
        return false;
    }

    private static PyException error(Exception e) {
        return Py.JavaError(e);
    }
}

