/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.python.antlr.ast.modType;
import org.python.core.AllFunction;
import org.python.core.AnyFunction;
import org.python.core.BuiltinFunctions;
import org.python.core.CompilerFlags;
import org.python.core.ImportFunction;
import org.python.core.MaxFunction;
import org.python.core.MinFunction;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyBaseString;
import org.python.core.PyBoolean;
import org.python.core.PyCallIter;
import org.python.core.PyClassMethod;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyEnumerate;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFrozenSet;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyProperty;
import org.python.core.PyReversedIterator;
import org.python.core.PySet;
import org.python.core.PySlice;
import org.python.core.PyStaticMethod;
import org.python.core.PyString;
import org.python.core.PyStringDerived;
import org.python.core.PyStringMap;
import org.python.core.PySuper;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.PyXRange;
import org.python.core.RoundFunction;
import org.python.core.SortedFunction;
import org.python.core.imp;
import org.python.core.util.RelativeFile;

public class __builtin__ {
    private static final PyStringMap internedStrings = new PyStringMap();
    public static PyString __doc__zip = new PyString("zip(seq1 [, seq2 [...]]) -> [(seq1[0], seq2[0] ...), (...)]\n\nReturn a list of tuples, where each tuple contains the i-th element\nfrom each of the argument sequences.  The returned list is\ntruncated in length to the length of the shortest argument sequence.");

    public static void fillWithBuiltins(PyObject dict) {
        dict.__setitem__("object", (PyObject)PyObject.TYPE);
        dict.__setitem__("type", (PyObject)PyType.TYPE);
        dict.__setitem__("bool", (PyObject)PyBoolean.TYPE);
        dict.__setitem__("int", (PyObject)PyInteger.TYPE);
        dict.__setitem__("enumerate", (PyObject)PyEnumerate.TYPE);
        dict.__setitem__("float", (PyObject)PyFloat.TYPE);
        dict.__setitem__("long", (PyObject)PyLong.TYPE);
        dict.__setitem__("complex", (PyObject)PyComplex.TYPE);
        dict.__setitem__("dict", (PyObject)PyDictionary.TYPE);
        dict.__setitem__("list", (PyObject)PyList.TYPE);
        dict.__setitem__("tuple", (PyObject)PyTuple.TYPE);
        dict.__setitem__("set", (PyObject)PySet.TYPE);
        dict.__setitem__("frozenset", (PyObject)PyFrozenSet.TYPE);
        dict.__setitem__("property", (PyObject)PyProperty.TYPE);
        dict.__setitem__("staticmethod", (PyObject)PyStaticMethod.TYPE);
        dict.__setitem__("classmethod", (PyObject)PyClassMethod.TYPE);
        dict.__setitem__("super", (PyObject)PySuper.TYPE);
        dict.__setitem__("str", (PyObject)PyString.TYPE);
        dict.__setitem__("unicode", (PyObject)PyUnicode.TYPE);
        dict.__setitem__("basestring", (PyObject)PyBaseString.TYPE);
        dict.__setitem__("file", (PyObject)PyFile.TYPE);
        dict.__setitem__("open", (PyObject)PyFile.TYPE);
        dict.__setitem__("slice", (PyObject)PySlice.TYPE);
        dict.__setitem__("xrange", (PyObject)PyXRange.TYPE);
        dict.__setitem__("None", Py.None);
        dict.__setitem__("NotImplemented", Py.NotImplemented);
        dict.__setitem__("Ellipsis", Py.Ellipsis);
        dict.__setitem__("True", (PyObject)Py.True);
        dict.__setitem__("False", (PyObject)Py.False);
        dict.__setitem__("__debug__", (PyObject)Py.One);
        dict.__setitem__("abs", (PyObject)new BuiltinFunctions("abs", 7, 1));
        dict.__setitem__("apply", (PyObject)new BuiltinFunctions("apply", 9, 1, 3));
        dict.__setitem__("callable", (PyObject)new BuiltinFunctions("callable", 14, 1));
        dict.__setitem__("coerce", (PyObject)new BuiltinFunctions("coerce", 13, 2));
        dict.__setitem__("chr", (PyObject)new BuiltinFunctions("chr", 0, 1));
        dict.__setitem__("cmp", (PyObject)new BuiltinFunctions("cmp", 6, 2));
        dict.__setitem__("globals", (PyObject)new BuiltinFunctions("globals", 4, 0));
        dict.__setitem__("hash", (PyObject)new BuiltinFunctions("hash", 5, 1));
        dict.__setitem__("id", (PyObject)new BuiltinFunctions("id", 11, 1));
        dict.__setitem__("isinstance", (PyObject)new BuiltinFunctions("isinstance", 10, 2));
        dict.__setitem__("len", (PyObject)new BuiltinFunctions("len", 1, 1));
        dict.__setitem__("ord", (PyObject)new BuiltinFunctions("ord", 3, 1));
        dict.__setitem__("range", (PyObject)new BuiltinFunctions("range", 2, 1, 3));
        dict.__setitem__("sum", (PyObject)new BuiltinFunctions("sum", 12, 1, 2));
        dict.__setitem__("unichr", (PyObject)new BuiltinFunctions("unichr", 6, 1));
        dict.__setitem__("compile", (PyObject)new BuiltinFunctions("compile", 44, 3, -1));
        dict.__setitem__("delattr", (PyObject)new BuiltinFunctions("delattr", 15, 2));
        dict.__setitem__("dir", (PyObject)new BuiltinFunctions("dir", 16, 0, 1));
        dict.__setitem__("divmod", (PyObject)new BuiltinFunctions("divmod", 17, 2));
        dict.__setitem__("eval", (PyObject)new BuiltinFunctions("eval", 18, 1, 3));
        dict.__setitem__("execfile", (PyObject)new BuiltinFunctions("execfile", 19, 1, 3));
        dict.__setitem__("filter", (PyObject)new BuiltinFunctions("filter", 20, 2));
        dict.__setitem__("getattr", (PyObject)new BuiltinFunctions("getattr", 21, 2, 3));
        dict.__setitem__("hasattr", (PyObject)new BuiltinFunctions("hasattr", 22, 2));
        dict.__setitem__("hex", (PyObject)new BuiltinFunctions("hex", 23, 1));
        dict.__setitem__("input", (PyObject)new BuiltinFunctions("input", 24, 0, 1));
        dict.__setitem__("intern", (PyObject)new BuiltinFunctions("intern", 25, 1));
        dict.__setitem__("issubclass", (PyObject)new BuiltinFunctions("issubclass", 26, 2));
        dict.__setitem__("iter", (PyObject)new BuiltinFunctions("iter", 27, 1, 2));
        dict.__setitem__("locals", (PyObject)new BuiltinFunctions("locals", 28, 0));
        dict.__setitem__("map", (PyObject)new BuiltinFunctions("map", 29, 2, -1));
        dict.__setitem__("max", (PyObject)new MaxFunction());
        dict.__setitem__("min", (PyObject)new MinFunction());
        dict.__setitem__("oct", (PyObject)new BuiltinFunctions("oct", 32, 1));
        dict.__setitem__("pow", (PyObject)new BuiltinFunctions("pow", 33, 2, 3));
        dict.__setitem__("raw_input", (PyObject)new BuiltinFunctions("raw_input", 34, 0, 1));
        dict.__setitem__("reduce", (PyObject)new BuiltinFunctions("reduce", 35, 2, 3));
        dict.__setitem__("reload", (PyObject)new BuiltinFunctions("reload", 36, 1));
        dict.__setitem__("repr", (PyObject)new BuiltinFunctions("repr", 37, 1));
        dict.__setitem__("round", (PyObject)new RoundFunction());
        dict.__setitem__("setattr", (PyObject)new BuiltinFunctions("setattr", 39, 3));
        dict.__setitem__("vars", (PyObject)new BuiltinFunctions("vars", 41, 0, 1));
        dict.__setitem__("zip", (PyObject)new BuiltinFunctions("zip", 43, 0, -1));
        dict.__setitem__("reversed", (PyObject)new BuiltinFunctions("reversed", 45, 1));
        dict.__setitem__("__import__", (PyObject)new ImportFunction());
        dict.__setitem__("sorted", (PyObject)new SortedFunction());
        dict.__setitem__("all", (PyObject)new AllFunction());
        dict.__setitem__("any", (PyObject)new AnyFunction());
    }

    public static PyObject abs(PyObject o) {
        return o.__abs__();
    }

    public static PyObject apply(PyObject o) {
        return o.__call__();
    }

    public static PyObject apply(PyObject o, PyObject args) {
        return o.__call__(Py.make_array(args));
    }

    public static PyObject apply(PyObject o, PyObject args, PyDictionary kws) {
        ConcurrentMap<PyObject, PyObject> table = kws.table;
        if (table.size() > 0) {
            Iterator ik = table.keySet().iterator();
            Iterator iv = table.values().iterator();
            int n = table.size();
            String[] kw = new String[n];
            PyObject[] aargs = Py.make_array(args);
            PyObject[] a = new PyObject[n + aargs.length];
            System.arraycopy(aargs, 0, a, 0, aargs.length);
            int offset = aargs.length;
            for (int i = 0; i < n; ++i) {
                kw[i] = ((PyString)ik.next()).internedString();
                a[i + offset] = (PyObject)iv.next();
            }
            return o.__call__(a, kw);
        }
        return __builtin__.apply(o, args);
    }

    public static boolean callable(PyObject obj) {
        return obj.isCallable();
    }

    public static int unichr(int i) {
        if (i < 0 || i > 0x10FFFF) {
            throw Py.ValueError("unichr() arg not in range(0x110000)");
        }
        return i;
    }

    public static char chr(int i) {
        if (i < 0 || i > 255) {
            throw Py.ValueError("chr() arg not in range(256)");
        }
        return (char)i;
    }

    public static int cmp(PyObject x, PyObject y) {
        return x._cmp(y);
    }

    public static PyTuple coerce(PyObject o1, PyObject o2) {
        PyObject[] result = o1._coerce(o2);
        if (result != null) {
            return new PyTuple(result);
        }
        throw Py.TypeError("number coercion failed");
    }

    public static PyObject compile(String data, String filename, String kind) {
        return Py.compile_flags(data, filename, kind, Py.getCompilerFlags());
    }

    public static PyObject compile(modType node, String filename, String kind) {
        return Py.compile_flags(node, filename, kind, Py.getCompilerFlags());
    }

    public static PyObject compile(String data, String filename, String kind, int flags, boolean dont_inherit) {
        if ((flags & 0xFFFF18EF) != 0) {
            throw Py.ValueError("compile(): unrecognised flags");
        }
        return Py.compile_flags(data, filename, kind, Py.getCompilerFlags(flags, dont_inherit));
    }

    public static PyObject compile(modType node, String filename, String kind, int flags, boolean dont_inherit) {
        if ((flags & 0xFFFF18EF) != 0) {
            throw Py.ValueError("compile(): unrecognised flags");
        }
        return Py.compile_flags(node, filename, kind, Py.getCompilerFlags(flags, dont_inherit));
    }

    public static void delattr(PyObject o, String n) {
        o.__delattr__(n);
    }

    public static PyObject dir(PyObject o) {
        PyList ret = (PyList)o.__dir__();
        ret.sort();
        return ret;
    }

    public static PyObject dir() {
        PyList ret;
        PyObject l = __builtin__.locals();
        PyObject retObj = l.invoke("keys");
        try {
            ret = (PyList)retObj;
        }
        catch (ClassCastException e) {
            throw Py.TypeError("Expected keys() to be a list, not '" + retObj.getType().fastGetName() + "'");
        }
        ret.sort();
        return ret;
    }

    public static PyObject divmod(PyObject x, PyObject y) {
        return x._divmod(y);
    }

    public static PyEnumerate enumerate(PyObject seq) {
        return new PyEnumerate(seq);
    }

    private static boolean PyMapping_check(PyObject o, boolean rw) {
        return o == null || o == Py.None || o instanceof PyDictionary || o.__findattr__("__getitem__") != null && (!rw || o.__findattr__("__setitem__") != null);
    }

    private static void verify_mappings(PyObject globals, PyObject locals, boolean rw) {
        if (!__builtin__.PyMapping_check(globals, rw)) {
            throw Py.TypeError("globals must be a mapping");
        }
        if (!__builtin__.PyMapping_check(locals, rw)) {
            throw Py.TypeError("locals must be a mapping");
        }
    }

    public static PyObject eval(PyObject o, PyObject globals, PyObject locals) {
        PyCode code;
        __builtin__.verify_mappings(globals, locals, false);
        if (o instanceof PyCode) {
            code = (PyCode)o;
        } else if (o instanceof PyString) {
            code = (PyCode)__builtin__.compile(o.toString(), "<string>", "eval");
        } else {
            throw Py.TypeError("eval: argument 1 must be string or code object");
        }
        return Py.runCode(code, locals, globals);
    }

    public static PyObject eval(PyObject o, PyObject globals) {
        return __builtin__.eval(o, globals, globals);
    }

    public static PyObject eval(PyObject o) {
        if (o instanceof PyTableCode && ((PyTableCode)o).hasFreevars()) {
            throw Py.TypeError("code object passed to eval() may not contain free variables");
        }
        return __builtin__.eval(o, null, null);
    }

    public static void execfile(String name, PyObject globals, PyObject locals) {
        __builtin__.execfile_flags(name, globals, locals, Py.getCompilerFlags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execfile_flags(String name, PyObject globals, PyObject locals, CompilerFlags cflags) {
        PyCode code;
        FileInputStream file;
        __builtin__.verify_mappings(globals, locals, true);
        try {
            file = new FileInputStream(new RelativeFile(name));
        }
        catch (FileNotFoundException e) {
            throw Py.IOError(e);
        }
        try {
            code = (PyCode)Py.compile_flags(file, name, "exec", cflags);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
        }
        Py.runCode(code, locals, globals);
    }

    public static void execfile(String name, PyObject globals) {
        __builtin__.execfile(name, globals, globals);
    }

    public static void execfile(String name) {
        __builtin__.execfile(name, null, null);
    }

    public static PyObject filter(PyObject func, PyObject seq) {
        if (seq instanceof PyString) {
            if (seq instanceof PyUnicode) {
                return __builtin__.filterunicode(func, (PyUnicode)seq);
            }
            return __builtin__.filterstring(func, (PyString)seq);
        }
        if (seq instanceof PyTuple) {
            return __builtin__.filtertuple(func, (PyTuple)seq);
        }
        PyList list = new PyList();
        for (PyObject item : seq.asIterable()) {
            if (func == PyBoolean.TYPE || func == Py.None ? !item.__nonzero__() : !func.__call__(item).__nonzero__()) continue;
            list.append(item);
        }
        return list;
    }

    public static PyObject filterstring(PyObject func, PyString seq) {
        if (func == Py.None && seq.getType() == PyString.TYPE) {
            return seq;
        }
        StringBuilder builder = new StringBuilder();
        for (PyObject item : seq.asIterable()) {
            boolean ok = false;
            if (func == Py.None) {
                if (item.__nonzero__()) {
                    ok = true;
                }
            } else if (func.__call__(item).__nonzero__()) {
                ok = true;
            }
            if (!ok) continue;
            if (!(item instanceof PyString) || item instanceof PyUnicode) {
                throw Py.TypeError("can't filter str to str: __getitem__ returned different type");
            }
            builder.append(item.toString());
        }
        return new PyString(builder.toString());
    }

    public static PyObject filterunicode(PyObject func, PyUnicode seq) {
        if (func == Py.None && seq.getType() == PyUnicode.TYPE) {
            return seq;
        }
        StringBuilder builder = new StringBuilder();
        for (PyObject item : seq.asIterable()) {
            boolean ok = false;
            if (func == Py.None) {
                if (item.__nonzero__()) {
                    ok = true;
                }
            } else if (func.__call__(item).__nonzero__()) {
                ok = true;
            }
            if (!ok) continue;
            if (!(item instanceof PyUnicode)) {
                throw Py.TypeError("can't filter unicode to unicode: __getitem__ returned different type");
            }
            builder.append(item.toString());
        }
        return new PyUnicode(builder.toString());
    }

    public static PyObject filtertuple(PyObject func, PyTuple seq) {
        int len = seq.__len__();
        if (len == 0) {
            if (seq.getType() != PyTuple.TYPE) {
                seq = new PyTuple();
            }
            return seq;
        }
        PyList list = new PyList();
        for (int i = 0; i < len; ++i) {
            boolean ok = false;
            PyObject item = seq.__finditem__(i);
            if (func == Py.None) {
                if (item.__nonzero__()) {
                    ok = true;
                }
            } else if (func.__call__(item).__nonzero__()) {
                ok = true;
            }
            if (!ok) continue;
            list.append(item);
        }
        return PyTuple.fromIterable(list);
    }

    public static PyObject getattr(PyObject obj, PyObject name) {
        return __builtin__.getattr(obj, name, null);
    }

    public static PyObject getattr(PyObject obj, PyObject name, PyObject def) {
        PyObject result;
        String nameStr;
        if (name instanceof PyUnicode) {
            nameStr = ((PyUnicode)name).encode();
        } else if (name instanceof PyString) {
            nameStr = name.asString();
        } else {
            throw Py.TypeError("getattr(): attribute name must be string");
        }
        try {
            result = obj.__getattr__(nameStr.intern());
        }
        catch (PyException pye) {
            if (Py.matchException(pye, Py.AttributeError) && def != null) {
                result = def;
            }
            throw pye;
        }
        return result;
    }

    public static PyObject globals() {
        return Py.getFrame().f_globals;
    }

    public static boolean hasattr(PyObject obj, PyObject name) {
        String nameStr;
        if (name instanceof PyUnicode) {
            nameStr = ((PyUnicode)name).encode().intern();
        } else if (name instanceof PyString) {
            nameStr = name.asString();
        } else {
            throw Py.TypeError("hasattr(): attribute name must be string");
        }
        try {
            return obj.__findattr__(nameStr.intern()) != null;
        }
        catch (PyException pyException) {
            return false;
        }
    }

    public static PyInteger hash(PyObject o) {
        return o.__hash__();
    }

    public static PyString hex(PyObject o) {
        return o.__hex__();
    }

    public static long id(PyObject o) {
        return Py.id(o);
    }

    public static PyObject input(PyObject prompt) {
        String line = __builtin__.raw_input(prompt);
        return __builtin__.eval(new PyString(line));
    }

    public static PyObject input() {
        return __builtin__.input(new PyString(""));
    }

    public static PyString intern(PyObject obj) {
        if (!(obj instanceof PyString) || obj instanceof PyUnicode) {
            throw Py.TypeError("intern() argument 1 must be string, not " + obj.getType().fastGetName());
        }
        if (obj.getType() != PyString.TYPE) {
            throw Py.TypeError("can't intern subclass of string");
        }
        PyString s = (PyString)obj;
        if (s instanceof PyStringDerived) {
            throw Py.TypeError("can't intern subclass of string");
        }
        String istring = s.internedString();
        PyObject ret = internedStrings.__finditem__(istring);
        if (ret != null) {
            return (PyString)ret;
        }
        internedStrings.__setitem__(istring, (PyObject)s);
        return s;
    }

    public static boolean isinstance(PyObject obj, PyObject cls) {
        return Py.isInstance(obj, cls);
    }

    public static boolean issubclass(PyObject derived, PyObject cls) {
        return Py.isSubClass(derived, cls);
    }

    public static PyObject iter(PyObject obj) {
        return obj.__iter__();
    }

    public static PyObject iter(PyObject callable, PyObject sentinel) {
        return new PyCallIter(callable, sentinel);
    }

    public static int len(PyObject o) {
        try {
            return o.__len__();
        }
        catch (PyException e) {
            if (e.type == Py.AttributeError && !(o instanceof PyInstance)) {
                throw Py.TypeError("len() of unsized object");
            }
            throw e;
        }
    }

    public static PyObject locals() {
        return Py.getFrame().getLocals();
    }

    public static PyObject map(PyObject[] argstar) {
        int n = argstar.length - 1;
        if (n < 1) {
            throw Py.TypeError("map requires at least two arguments");
        }
        PyObject f = argstar[0];
        PyList list = new PyList();
        PyObject[] args = new PyObject[n];
        PyObject[] iters = new PyObject[n];
        for (int j = 0; j < n; ++j) {
            iters[j] = Py.iter(argstar[j + 1], "argument " + (j + 1) + " to map() must support iteration");
        }
        while (true) {
            boolean any_items = false;
            for (int j = 0; j < n; ++j) {
                PyObject element = iters[j].__iternext__();
                if (element != null) {
                    args[j] = element;
                    any_items = true;
                    continue;
                }
                args[j] = Py.None;
            }
            if (!any_items) break;
            if (f == Py.None) {
                if (n == 1) {
                    list.append(args[0]);
                    continue;
                }
                list.append(new PyTuple((PyObject[])args.clone()));
                continue;
            }
            list.append(f.__call__(args));
        }
        return list;
    }

    public static PyString oct(PyObject o) {
        return o.__oct__();
    }

    public static final int ord(PyObject c) {
        int length;
        PyString x = (PyString)c;
        if (x instanceof PyUnicode) {
            length = x.string.codePointCount(0, x.string.length());
            if (length == 1) {
                return x.string.codePointAt(0);
            }
        } else {
            length = x.string.length();
            if (length == 1) {
                return x.string.charAt(0);
            }
        }
        throw Py.TypeError("ord() expected a character, but string of length " + length + " found");
    }

    public static PyObject pow(PyObject x, PyObject y) {
        return x._pow(y);
    }

    private static boolean coerce(PyObject[] objs) {
        PyObject x = objs[0];
        PyObject y = objs[1];
        PyObject[] result = x._coerce(y);
        if (result != null) {
            objs[0] = result[0];
            objs[1] = result[1];
            return true;
        }
        result = y._coerce(x);
        if (result != null) {
            objs[0] = result[1];
            objs[1] = result[0];
            return true;
        }
        return false;
    }

    public static PyObject pow(PyObject x, PyObject y, PyObject z) {
        PyObject result;
        if (z == Py.None) {
            return __builtin__.pow(x, y);
        }
        PyObject[] tmp = new PyObject[]{x, y};
        if (__builtin__.coerce(tmp)) {
            x = tmp[0];
            y = tmp[1];
            tmp[1] = z;
            if (__builtin__.coerce(tmp)) {
                x = tmp[0];
                z = tmp[1];
                tmp[0] = y;
                if (__builtin__.coerce(tmp)) {
                    z = tmp[1];
                    y = tmp[0];
                }
            }
        } else {
            tmp[1] = z;
            if (__builtin__.coerce(tmp)) {
                x = tmp[0];
                z = tmp[1];
                tmp[0] = y;
                if (__builtin__.coerce(tmp)) {
                    y = tmp[0];
                    z = tmp[1];
                    tmp[1] = x;
                    if (__builtin__.coerce(tmp)) {
                        x = tmp[1];
                        y = tmp[0];
                    }
                }
            }
        }
        if ((result = x.__pow__(y, z)) != null) {
            return result;
        }
        throw Py.TypeError(String.format("unsupported operand type(s) for pow(): '%.100s', '%.100s', '%.100s'", x.getType().fastGetName(), y.getType().fastGetName(), z.getType().fastGetName()));
    }

    public static PyObject range(PyObject start, PyObject stop, PyObject step) {
        int ilow = 0;
        int ihigh = 0;
        int istep = 1;
        try {
            ilow = start.asInt();
            ihigh = stop.asInt();
            istep = step.asInt();
        }
        catch (PyException pye) {
            return __builtin__.handleRangeLongs(start, stop, step);
        }
        if (istep == 0) {
            throw Py.ValueError("range() step argument must not be zero");
        }
        int n = istep > 0 ? PyXRange.getLenOfRange(ilow, ihigh, istep) : PyXRange.getLenOfRange(ihigh, ilow, -istep);
        if (n < 0) {
            throw Py.OverflowError("range() result has too many items");
        }
        PyObject[] range = new PyObject[n];
        int i = 0;
        while (i < n) {
            range[i] = Py.newInteger(ilow);
            ++i;
            ilow += istep;
        }
        return new PyList(range);
    }

    public static PyObject range(PyObject n) {
        return __builtin__.range(Py.Zero, n, Py.One);
    }

    public static PyObject range(PyObject start, PyObject stop) {
        return __builtin__.range(start, stop, Py.One);
    }

    private static PyObject handleRangeLongs(PyObject ilow, PyObject ihigh, PyObject istep) {
        if (!(ilow instanceof PyInteger) && !(ilow instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer start argument expected, got %s.", ilow.getType().fastGetName()));
        }
        if (!(ihigh instanceof PyInteger) && !(ihigh instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer end argument expected, got %s.", ihigh.getType().fastGetName()));
        }
        if (!(istep instanceof PyInteger) && !(istep instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer step argument expected, got %s.", istep.getType().fastGetName()));
        }
        int cmpResult = istep._cmp(Py.Zero);
        if (cmpResult == 0) {
            throw Py.ValueError("range() step argument must not be zero");
        }
        int n = cmpResult > 0 ? __builtin__.getLenOfRangeLongs(ilow, ihigh, istep) : __builtin__.getLenOfRangeLongs(ihigh, ilow, istep.__neg__());
        if (n < 0) {
            throw Py.OverflowError("range() result has too many items");
        }
        PyObject[] range = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            range[i] = ilow.__long__();
            ilow = ilow.__add__(istep);
        }
        return new PyList(range);
    }

    private static int getLenOfRangeLongs(PyObject lo, PyObject hi, PyObject step) {
        if (lo._cmp(hi) >= 0) {
            return 0;
        }
        try {
            PyObject diff = hi.__sub__(lo).__sub__(Py.One);
            PyObject n = diff.__floordiv__(step).__add__(Py.One);
            return n.asInt();
        }
        catch (PyException pye) {
            return -1;
        }
    }

    private static PyString readline(PyObject file) {
        if (file instanceof PyFile) {
            return ((PyFile)file).readline();
        }
        PyObject ret = file.invoke("readline");
        if (!(ret instanceof PyString)) {
            throw Py.TypeError("object.readline() returned non-string");
        }
        return (PyString)ret;
    }

    public static String raw_input(PyObject prompt, PyObject file) {
        PyObject stdout = Py.getSystemState().stdout;
        if (stdout instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("[raw_]input: lost sys.stdout");
        }
        Py.print(stdout, prompt);
        String data = __builtin__.readline(file).toString();
        if (data.endsWith("\n")) {
            return data.substring(0, data.length() - 1);
        }
        if (data.length() == 0) {
            throw Py.EOFError("raw_input()");
        }
        return data;
    }

    public static String raw_input(PyObject prompt) {
        PyObject stdin = Py.getSystemState().stdin;
        if (stdin instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("[raw_]input: lost sys.stdin");
        }
        return __builtin__.raw_input(prompt, stdin);
    }

    public static String raw_input() {
        return __builtin__.raw_input(new PyString(""));
    }

    public static PyObject reduce(PyObject f, PyObject l, PyObject z) {
        PyObject item;
        PyObject result = z;
        PyObject iter = Py.iter(l, "reduce() arg 2 must support iteration");
        while ((item = iter.__iternext__()) != null) {
            if (result == null) {
                result = item;
                continue;
            }
            result = f.__call__(result, item);
        }
        if (result == null) {
            throw Py.TypeError("reduce of empty sequence with no initial value");
        }
        return result;
    }

    public static PyObject reduce(PyObject f, PyObject l) {
        return __builtin__.reduce(f, l, null);
    }

    public static PyObject reload(PyModule o) {
        return imp.reload(o);
    }

    public static PyObject reload(PyJavaClass o) {
        return imp.reload(o);
    }

    public static PyObject reload(PySystemState o) {
        o.reload();
        return o;
    }

    public static PyString repr(PyObject o) {
        return o.__repr__();
    }

    public static void setattr(PyObject o, String n, PyObject v) {
        o.__setattr__(n, v);
    }

    public static PyObject sum(PyObject seq, PyObject result) {
        if (result instanceof PyString) {
            throw Py.TypeError("sum() can't sum strings [use ''.join(seq) instead]");
        }
        for (PyObject item : seq.asIterable()) {
            result = result._add(item);
        }
        return result;
    }

    public static PyObject reversed(PyObject seq) {
        if (seq.__findattr__("__getitem__") != null && seq.__findattr__("__len__") != null && seq.__findattr__("keys") == null) {
            return new PyReversedIterator(seq);
        }
        throw Py.TypeError("argument to reversed() must be a sequence");
    }

    public static PyObject sum(PyObject seq) {
        return __builtin__.sum(seq, Py.Zero);
    }

    public static PyType type(PyObject o) {
        return o.getType();
    }

    public static PyObject vars() {
        return __builtin__.locals();
    }

    public static PyObject vars(PyObject o) {
        try {
            return o.__getattr__("__dict__");
        }
        catch (PyException e) {
            if (Py.matchException(e, Py.AttributeError)) {
                throw Py.TypeError("vars() argument must have __dict__ attribute");
            }
            throw e;
        }
    }

    public static PyObject zip() {
        return new PyList();
    }

    public static PyObject zip(PyObject[] argstar) {
        int itemsize = argstar.length;
        PyObject[] iters = new PyObject[itemsize];
        for (int j = 0; j < itemsize; ++j) {
            PyObject iter = argstar[j].__iter__();
            if (iter == null) {
                throw Py.TypeError("zip argument #" + (j + 1) + " must support iteration");
            }
            iters[j] = iter;
        }
        PyList ret = new PyList();
        int i = 0;
        while (true) {
            PyObject[] next = new PyObject[itemsize];
            for (int j = 0; j < itemsize; ++j) {
                PyObject item;
                try {
                    item = iters[j].__iternext__();
                }
                catch (PyException e) {
                    if (Py.matchException(e, Py.StopIteration)) {
                        return ret;
                    }
                    throw e;
                }
                if (item == null) {
                    return ret;
                }
                next[j] = item;
            }
            ret.append(new PyTuple(next));
            ++i;
        }
    }

    public static PyObject __import__(String name) {
        return __builtin__.__import__(name, null, null, null, -1);
    }

    public static PyObject __import__(String name, PyObject globals) {
        return __builtin__.__import__(name, globals, null, null, -1);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals) {
        return __builtin__.__import__(name, globals, locals, null, -1);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals, PyObject fromlist) {
        return __builtin__.__import__(name, globals, locals, fromlist, -1);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals, PyObject fromlist, int level) {
        PyObject __import__;
        PyFrame frame = Py.getFrame();
        if (frame == null) {
            return null;
        }
        PyObject builtins = frame.f_builtins;
        if (builtins == null) {
            builtins = PySystemState.builtins;
        }
        if ((__import__ = builtins.__finditem__("__import__")) == null) {
            return null;
        }
        PyObject module = __import__.__call__(new PyObject[]{Py.newString(name), globals, locals, fromlist, Py.newInteger(level)});
        return module;
    }
}

