/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import org.python.core.BytecodeLoader;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.expose.generate.InterpTestCase;
import org.python.expose.generate.OverridableNewExposer;
import org.python.expose.generate.PyTypes;
import org.python.objectweb.asm.Opcodes;
import org.python.objectweb.asm.Type;

public class OverridableNewExposerTest
extends InterpTestCase
implements PyTypes,
Opcodes {
    private OverridableNewExposer ne;
    private PyNewWrapper instance;
    private PyType type;

    public void setUp() throws Exception {
        super.setUp();
        this.ne = new OverridableNewExposer(Type.getType(Instantiable.class), Type.getType(Instantiable.class), 1, "creator", Type.getMethodDescriptor(VOID, new Type[]{APYOBJ, ASTRING}), new String[0]);
        Class<?> descriptor = this.ne.load(new BytecodeLoader.Loader());
        this.instance = (PyNewWrapper)descriptor.newInstance();
        this.type = PyType.fromClass(Instantiable.class);
        this.instance.setWrappedType(this.type);
    }

    public void testSimple() throws Exception {
        OverridableNewExposerTest.assertEquals((String)"org/python/expose/generate/OverridableNewExposerTest$Instantiable$exposed___new__", (String)this.ne.getInternalName());
        OverridableNewExposerTest.assertEquals((String)"org.python.expose.generate.OverridableNewExposerTest$Instantiable$exposed___new__", (String)this.ne.getClassName());
        OverridableNewExposerTest.assertSame((Object)"__new__", (Object)this.instance.__getattr__("__name__").toString());
        Instantiable created = (Instantiable)this.instance.__call__(this.type);
        OverridableNewExposerTest.assertEquals((String)"Just calling the actual new doesn't call its init", (int)0, (int)created.timesCalled);
        created = (Instantiable)this.instance.new_impl(true, this.type, Py.EmptyObjects, Py.NoKeywords);
        OverridableNewExposerTest.assertEquals((String)"Passing true to new_init should get the init method called", (int)1, (int)created.timesCalled);
        OverridableNewExposerTest.assertEquals((String)"the regular type is passed in for normal instantiation", (Object)this.type, (Object)created.forType);
    }

    public void testSubtype() throws Exception {
        PyType sub = (PyType)PyType.newType(new PyNewWrapper(){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                return new Instantiable(subtype);
            }
        }, PyType.TYPE, "subinst", new PyTuple(new PyObject[]{this.type}), new PyDictionary());
        Instantiable created = (Instantiable)this.instance.new_impl(true, sub, Py.EmptyObjects, Py.NoKeywords);
        OverridableNewExposerTest.assertEquals((String)"new's init isn't called when a subtype comes in", (int)0, (int)created.timesCalled);
        OverridableNewExposerTest.assertSame((String)"the subtype is created when a subtype is passed in", (Object)sub, (Object)created.forType);
    }

    @ExposedType
    public static class Instantiable
    extends PyObject {
        private PyType forType;
        private int timesCalled;

        public Instantiable(PyType forType) {
            this.forType = forType;
        }

        @ExposedNew
        public void creator(PyObject[] args, String[] keywords) {
            ++this.timesCalled;
        }
    }
}

