% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate2D.R
\name{rotate2D}
\alias{rotate2D}
\title{Rotate a plane of coordinates}
\usage{
rotate2D(plane, angle, threads = 1)
}
\arguments{
\item{plane}{A \code{data.table} with two columns describing the plane of coordinates.}

\item{angle}{A \code{numeric} vector describing the degrees of rotation.}

\item{threads}{An \code{integer} specifying the number of threads to use. Experiment to see what works best for your data on your hardware.}
}
\value{
A \code{data.table} with the rotation applied to \code{plane}.
}
\description{
Rotate a plane of coordinates to a given angle.
}
\examples{

data(pc_tree)

plot(pc_tree[,1:2])

#Rotate in 45 degrees using Z axis of the cloud
plot(rotate2D(pc_tree[,1:2], angle = 45))

}
\author{
J. Antonio Guzmán Q.
}
