\name{khatri_rao_list}
\alias{khatri_rao_list}
\title{List Khatri-Rao Product}
\usage{
  khatri_rao_list(L, reverse = FALSE)
}
\arguments{
  \item{L}{list of matrices or vectors}

  \item{reverse}{whether or not to reverse the order}
}
\value{
  matrix that is the Khatri-Rao product
}
\description{
  Returns the Khatri-Rao product from a list of matrices or
  vectors. Commonly used for n-mode products and various
  Tensor decompositions.
}
\note{
  The number of columns must match in every element of the
  input list.
}
\examples{
smalllizt <- list('mat1' = matrix(runif(12),ncol=4),
'mat2' = matrix(runif(12),ncol=4),
'mat3' = matrix(runif(12),ncol=4))
dim(khatri_rao_list(smalllizt))
}
\seealso{
  \code{\link{khatri_rao}}
}

