% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qsm.R
\name{plot_qsm}
\alias{plot_qsm}
\title{Plot QSM}
\usage{
plot_qsm(
  cylinder,
  radius = NULL,
  color = NULL,
  palette = NULL,
  facets = 6,
  cloud = NULL,
  pt_color = NULL,
  pt_size = NULL,
  axes = TRUE,
  hover = FALSE,
  skeleton = FALSE,
  bg_color = NULL
)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{radius}{Column name of radii as a quoted string. Defaults to the modified radii.}

\item{color}{Optional cylinder color parameter. Colors must be a single hex color, a vector of hex colors, or a quoted column name. It can also be set to "random" to generate a random solid color. Vectors must have the same length as the cylinder data frame.}

\item{palette}{Optional color palette for numerical data. Palettes include: viridis, inferno, plasma, magma, cividis, and rainbow.}

\item{facets}{The number of facets in the polygon cross section. Defaults to 6, but can be increased to improve visual smoothness at the cost of performance and memory.}

\item{cloud}{Point cloud data frame where the first three columns are the x, y, and z coordinates in the same coordinate system as the QSM. Defaults to NULL.}

\item{pt_color}{Color of the point cloud. Defaults to black. Can be set to "random".}

\item{pt_size}{Size of the points. Defaults to 0.1.}

\item{axes}{Show plot axes. Defaults to TRUE.}

\item{hover}{Show cylinder and branch id on mouse hover. Defaults to FALSE.}

\item{skeleton}{Plot the QSM skeleton instead of cylinders. Defaults to FALSE.}

\item{bg_color}{Set the background color of the rgl plot. Defaults to NULL.}
}
\value{
A rgl plot
}
\description{
Plots QSM cylinders and point clouds using the rgl library
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)
plot_qsm(cylinder)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder2 <- read.csv(file)
cylinder2 <- update_cylinders(cylinder2)
plot_qsm(cylinder2)

## All Parameters
file2 <- system.file("extdata/cloud.txt", package = "rTwig")
cloud <- read.table(file2, header = FALSE)

plot_qsm(
  cylinder,
  radius = "UnmodRadius",
  color = "growthLength",
  palette = "viridis",
  facets = 100,
  cloud = cloud,
  pt_color = "random",
  pt_size = 1,
  axes = FALSE,
  hover = TRUE,
  bg_color = "black"
)

}
