% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_metrics.R
\name{tree_metrics}
\alias{tree_metrics}
\title{Tree Metrics}
\usage{
tree_metrics(cylinder)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}
}
\value{
Returns a list of tree metric data frames and synthetic point cloud
}
\description{
Calculates tree metrics from a QSM
}
\details{
Calculates detailed tree, branch, and segment metrics from a QSM.
The outputs include all of the standard outputs from TreeQSM, and also
additional variables, including, but not limited to, growth length,
reverse branch order, branch segment or node relationships, and distances
from twigs and the base of the tree, across various distribution metrics.
Also included is a simulated point cloud of the tree, based on the QSM
cylinder radii. When corrected with Real Twig, this allow for the testing and
validation of point cloud diameter overestimation throughout the tree.
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
cylinder <- import_qsm(file)$cylinder
cylinder <- update_cylinders(cylinder)
metrics <- tree_metrics(cylinder)
names(metrics)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)
metrics <- tree_metrics(cylinder)
names(metrics)

}
\references{
\insertRef{TreeQSM}{rTwig}

\insertRef{growth_parameter1}{rTwig}

\insertRef{growth_parameter2}{rTwig}

\insertRef{treegraph2}{rTwig}
}
