% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_prop.R
\name{single_prop}
\alias{single_prop}
\title{Compare a sample proportion to a population proportion}
\usage{
single_prop(
  dataset,
  var,
  lev = "",
  comp_value = 0.5,
  alternative = "two.sided",
  conf_lev = 0.95,
  test = "binom",
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{var}{The variable selected for the proportion comparison}

\item{lev}{The factor level selected for the proportion comparison}

\item{comp_value}{Population value to compare to the sample proportion}

\item{alternative}{The alternative hypothesis ("two.sided", "greater", or "less")}

\item{conf_lev}{Span of the confidence interval}

\item{test}{bionomial exact test ("binom") or Z-test ("z")}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list of variables used in single_prop as an object of class single_prop
}
\description{
Compare a sample proportion to a population proportion
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/single_prop.html} for an example in Radiant
}
\examples{
single_prop(titanic, "survived") \%>\% str()
single_prop(titanic, "survived", lev = "Yes", comp_value = 0.5,  alternative = "less") \%>\% str()

}
\seealso{
\code{\link{summary.single_prop}} to summarize the results

\code{\link{plot.single_prop}} to plot the results
}
