% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivotr.R
\name{plot.pivotr}
\alias{plot.pivotr}
\title{Plot method for the pivotr function}
\usage{
\method{plot}{pivotr}(x, type = "dodge", perc = FALSE, flip = FALSE,
  shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{pivotr}}}

\item{type}{Plot type to use ("fill" or "dodge" (default))}

\item{perc}{Use percentage on the y-axis}

\item{flip}{Flip the axes in a plot (FALSE or TRUE)}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This opion can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org/} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the pivotr function
}
\details{
See \url{http://radiant-rstats.github.io/docs/data/pivotr} for an example in Radiant
}
\examples{
pivotr("diamonds", cvars = "cut") \%>\% plot
pivotr("diamonds", cvars = c("cut","clarity")) \%>\% plot
pivotr("diamonds", cvars = c("cut","clarity","color")) \%>\% plot

}
\seealso{
\code{\link{pivotr}} to generate summaries

\code{\link{summary.pivotr}} to show summaries
}

