% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\title{Visualize data using ggplot2 \url{http://docs.ggplot2.org/current/}}
\usage{
visualize(dataset, viz_xvar, viz_yvar = "none", data_filter = "",
  viz_type = "hist", viz_facet_row = ".", viz_facet_col = ".",
  viz_color = "none", viz_bins = 10, viz_smooth = 1, viz_check = "",
  viz_axes = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{viz_xvar}{One or more variables to display along the X-axis of the plot}

\item{viz_yvar}{Variable to display along the Y-axis of the plot (default = "none")}

\item{data_filter}{Expression used to filter the dataset. This should be a string (e.g., "price > 10000")}

\item{viz_type}{Type of plot to create. One of Histogram ('hist'), Density ('density'), Scatter ('scatter'), Line ('line'), Bar ('bar'), or Box-plot ('box')}

\item{viz_facet_row}{Create vertically arranged subplots for each level of the selected factor variable}

\item{viz_facet_col}{Create horizontally arranged subplots for each level of the selected factor variable}

\item{viz_color}{Adds color to a scatter plot to generate a heat map. For a line plot one line is created for each group and each is assigned a different colour}

\item{viz_bins}{Number of bins used for a histogram (not accessible in Radiant)}

\item{viz_smooth}{Adjust the flexibility of the loess line for scatter plots (not accessible in Radiant)}

\item{viz_check}{Add a regression line ("line"), a loess line ("loess"), or jitter ("jitter") to a scatter plot}

\item{viz_axes}{Flip the axes in a plot ("flip") or apply a log transformation (base e) to the y-axis ("log_y") or the x-axis ("log_x")}
}
\value{
Generated plots
}
\description{
Visualize data using ggplot2 \url{http://docs.ggplot2.org/current/}
}
\details{
See \url{http://vnijs.github.io/radiant/base/visualize.html} for an example in Radiant
}
\examples{
visualize("diamonds", "carat", "price", viz_type = "scatter", viz_check = "loess")
visualize("diamonds", "price:x", viz_type = "hist")
visualize("diamonds", "carat:x", viz_yvar = "price", viz_type = "scatter")
}

