% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GLCM.R
\docType{class}
\name{glcm-class}
\alias{glcm}
\alias{glcm-class}
\title{Gray level co-occurrence matrix.}
\arguments{
\item{data}{A numeric 2D matrix.}

\item{angle}{One of "0", "45", "90" or "135", the pixel to which the
current pixel is compared.}

\item{d}{an integer value, the distance between the current pixel, and the
pixel to which it is compared.}

\item{n_grey}{an integer value, the number of grey levels the image should
be quantized into. If greater than the number of unique values in the image,
no action will be taken.}

\item{normalize}{Logical value, if TRUE (default) the matrix will be normalized such that
the sum of it's components is 1.}

\item{...}{Can be given verbose=FALSE to suppress output from the n_grey conversion.}
}
\value{
a matrix of dimension n_grey by n_grey, the GLCM. The column and row names represent
  grey values in the image.

  See \url{http://www.fp.ucalgary.ca/mhallbey/tutorial.htm} for details.
}
\description{
\code{glcm} returns a gray level co-occurrence matrix for a given matrix.
}
\details{
Can be visualized using \code{image(glcm(data))}. For visualization info
see \code{?image.radiomics}
}
\examples{
\dontrun{
hallbey
glcm(hallbey)
glcm(hallbey, angle="90") #vertical GLCM
}
}
\references{
\url{http://www.fp.ucalgary.ca/mhallbey/tutorial.htm}
}

