% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MGLSZM.R
\docType{class}
\name{mglszm-class}
\alias{mglszm}
\alias{mglszm-class}
\title{Multiple gray level size zone matrix.}
\arguments{
\item{image}{A 2D image matrix.}

\item{truncate}{Logical, removes any sizes or gray levels that have no entries.}

\item{...}{Can be given verbose=FALSE to suppress output from the n_grey conversion.}
}
\value{
a matrix of dimension n_grey by region size, the MGLSZM. The column
  names represent the region size, row names represent grey level, and
  the entries represent the count of how many times a given size of given grey level
  occur.
}
\description{
\code{mglszm} returns a matrix of class "mglszm", the multiple gray level size zone
 matrix for a given matrix.
}
\details{
The function creates
a GLSZM using grey levels: 2, 4, 8, 16, 32, 64, 128, and 256. The values of these
GLSZM's are then weighted and combined using a gaussian distribution with mean
of 0 and sd of 1.

Can be visualized using \code{image(mglszm(data))}. For visualization info
see \code{?image.radiomics}
}
\examples{
\dontrun{
image(psf)
mglszm(psf)

image(discretizeImage(psf, n_grey=5, verbose=F))
mglszm(psf, n_grey=5, verbose=F)
}
}
\references{
\url{http://thibault.biz/Research/ThibaultMatrices/MGLSZM/MGLSZM.html}
}

