% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_cf.R
\name{dk_cf}
\alias{dk_cf}
\title{Correction factor for source decay.}
\usage{
dk_cf(half_life, date1, date2 = Sys.Date(), time_unit)
}
\arguments{
\item{half_life}{The half-life numeric value}

\item{date1}{Source reference date. If units are hours or shorter, include time. Format is "YYYY-mm-dd" for longer half-lives, or "YYYY-mm-dd-HH:MM".}

\item{date2}{Date of interest. Format is same as date1. Default is today's date, obtained from system.}

\item{time_unit, }{acceptable values are years, days, hours, and minutes.
These may be shortened to y, d, h and m. Must be entered in quotes.}
}
\value{
The decay correction factor from the reference date to the date of interest.
}
\description{
Compute correction value for decay of a single-isotope source.
}
\examples{
dk_cf(5.27,"2010-12-01", "2018-12-01", "y")
dk_cf(24, "2018-10-01-08:15","2018-10-01-09:15", "m")
}
