% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_time.R
\name{dk_time}
\alias{dk_time}
\title{Time to decay to target radioactivity.}
\usage{
dk_time(half_life, A0, A1)
}
\arguments{
\item{half_life, }{Half-life. Units are arbitrary, but must match time past.}

\item{A0}{The original activity, or related parameter.}

\item{A1}{The target activity.}
}
\value{
Time, in same units as half-life, to decay to target activity.
}
\description{
Calculate time for a radionuclide to decay to a target activity.
}
\examples{
# A carbonaceous artifact has a C-14 measurement of 1 dpm per g pure carbon.
# The reference activity is 14 dpm per g pure carbon. How old is our sample?
dk_time(half_life = 5730, A0 = 14, A1 = 1)
}
\seealso{
Other decay corrections: 
\code{\link{dk_correct}()},
\code{\link{dk_pct_to_num_half_life}()}
}
\concept{decay corrections}
