% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rAtte_fun.R
\name{genMat}
\alias{genMat}
\title{ramchoice Package: Generate Matrices of Constraints}
\usage{
genMat(sumMenu, sumMsize, pref_list = NULL, limDataCorr = TRUE)
}
\arguments{
\item{sumMenu}{Numeric matrix, summary of menus, returned by \code{\link{sumData}}.}

\item{sumMsize}{Numeric matrix, summary of menu sizes, returned by \code{\link{sumData}}.}

\item{pref_list}{Numeric matrix, each row corresponds to a preference. For example \code{c(2, 3, 1)} means
2 is preferred to 3 and to 1. When set to \code{NULL}, the default \code{c(1, 2, 3, ...)}
will be used.}

\item{limDataCorr}{Boolean, whether assumes limited data (default is \code{TRUE}). When set to
\code{FALSE}, will assume all menus/choice problems are observed, hence no correction.}
}
\value{
\item{R}{Matrices of constraints, stacked vertically.}
\item{ConstN}{The number of constraints for each preference, used to extract from \code{R}
  individual matrices of constraints.}
}
\description{
\code{genMat} generates matrices of constraints, imposed by the monotonicity
  assumption and preferences specified as the null hypotheses.

This function is embedded in \code{\link{rAtte}}, hence not needed to be called
  separately.
}
\examples{
# load data
data(ramdata)

# summary statistics
summaryStats <- sumData(menu, choice)

# constraints
constraints <- genMat(summaryStats$sumMenu,
  summaryStats$sumMsize, NULL)
constraints$ConstN
constraints$R[1:10, 1:10]

}
\references{
M. D. Cattaneo, X. Ma, Y. Masatlioglu and E. Suleymanov (2017). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Ma-Masatlioglu-Suleymanov_2017_RAM.pdf}{A Random Attention Model}. Working Paper, University of Michigan.
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, University of Michigan. \email{elchin@umich.edu}
}
