% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rAtte.R
\name{rAtte}
\alias{rAtte}
\title{rAtte: Estimation and Inference in Random Attention Models}
\usage{
rAtte(menu, choice, pref_list = NULL, method = "GMS", nCritSimu = 2000,
  BARatio2MS = 0.1, BARatio2UB = 0.1, MNRatioGMS = NULL,
  limDataCorr = TRUE, attBinary = 1)
}
\arguments{
\item{menu}{Numeric matrix of 0s and 1s, the collection of choice problems.}

\item{choice}{Numeric matrix of 0s and 1s, the collection of choices.}

\item{pref_list}{Numeric matrix, each row corresponds to one preference. For example, \code{c(2, 3, 1)} means
2 is preferred to 3 and to 1. When set to \code{NULL}, the default, \code{c(1, 2, 3, ...)},
will be used.}

\item{method}{String, the method for constructing critical values. Default is \code{GMS} (generalized moment selection).
Other available options are \code{LF} (least favorable model), \code{PI} (plug-in method), \code{2MS} (two-step moment selection),
\code{2UB} (two-step moment upper bound), or \code{ALL} (report all critical values).}

\item{nCritSimu}{Integer, number of simulations used to construct the critical value. Default is \code{2000}.}

\item{BARatio2MS}{Numeric, beta-to-alpha ratio for two-step moment selection method. Default is \code{0.1}.}

\item{BARatio2UB}{Numeric, beta-to-alpha ratio for two-step moment upper bound method. Default is \code{0.1}.}

\item{MNRatioGMS}{Numeric, shrinkage parameter. Default is \code{sqrt(1/log(N))}, where N is the sample size.}

\item{limDataCorr}{Boolean, whether assumes limited data (default is \code{TRUE}). When set to
\code{FALSE}, it will be assumed that all choice problems are observed.}

\item{attBinary}{Numeric, between 1/2 and 1 (default is \code{1}), whether additional restriction on the attention rule
should be imposed for binary choice problems (i.e., attentive at binaries).}
}
\value{
\item{sumStats}{Summary statistics, generated by \code{\link{sumData}}.}
\item{constraints}{Matrices of constraints, generated by \code{\link{genMat}}.}
\item{Tstat}{Test statistic.}
\item{critVal}{Critical values.}
\item{pVal}{P-values (only available for \code{GMS}, \code{LF} and \code{PI}).}
\item{method}{Method for constructing critical value.}
}
\description{
Given a random sample with choice problems and choices, \code{rAtte}
  returns test statistics, critical values and p-values against a collection of preferences.
  Five methods for choosing critical values are available:
  (i) \code{GMS}: generalized moment selection (plug-in (estimated) moment conditions with shrinkage);
  (ii) \code{PI}: critical values based on plug-in estimated moment conditions (this is not uniformly valid);
  (iii) \code{LF}: critical values based on the least favorable model (plug-in 0 for the moment conditions);
  (iv) \code{2MS}: two-step moment selection;
  and (v) \code{2UB}: refined moment selection (plug-in upper bound of moment inequalities).

\code{\link{sumData}} is a low-level function that generates summary statistics, and
  \code{\link{genMat}} can be used to construct the constraint matrices. The simulated dataset
  \code{\link{ramdata}} is also provided for illustration.
}
\examples{
# load data
data(ramdata)

# seed, to replicate simulated critical values
set.seed(42)

result <- rAtte(menu = ramdata$menu, choice = ramdata$choice, method = "GMS",
  pref_list=matrix(c(1, 2, 3, 4, 5,
                     2, 1, 3, 4, 5,
                     2, 3, 4, 5, 1,
                     5, 4, 3, 2, 1), ncol=5, byrow=TRUE))
summary(result)

result2 <- rAtte(menu = ramdata$menu, choice = ramdata$choice, method = "GMS", attBinary = 2/3,
  pref_list=matrix(c(1, 2, 3, 4, 5,
                     2, 1, 3, 4, 5,
                     2, 3, 4, 5, 1,
                     5, 4, 3, 2, 1), ncol=5, byrow=TRUE))
summary(result2)

}
\references{
M. D. Cattaneo, X. Ma, Y. Masatlioglu and E. Suleymanov (2019). \href{http://arxiv.org/abs/1712.03448}{A Random Attention Model}. Working Paper, University of Michigan.
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, University of Michigan. \email{elchin@umich.edu}
}
