/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.conceptdrift.utils;

import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.inference.messagepassing.Node;
import eu.amidst.core.learning.parametric.bayesian.utils.PlateuIIDReplication;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class PlateuHiddenVariableConceptDrift
extends PlateuIIDReplication {
    List<Variable> localHiddenVars;
    List<Node> localHiddenNodes;
    Map<Variable, Node> hiddenToNode;
    boolean dynamic;

    public PlateuHiddenVariableConceptDrift(List<Variable> localHiddenVars_, boolean dynamic_) {
        this.localHiddenVars = localHiddenVars_;
        this.dynamic = dynamic_;
    }

    @Override
    public void replicateModel() {
        int i;
        this.nonReplictedNodes = new ArrayList();
        this.replicatedNodes = new ArrayList(this.nReplications);
        this.replicatedVarsToNode = new ArrayList();
        this.nonReplicatedVarsToNode = new ConcurrentHashMap();
        this.nonReplictedNodes = this.ef_learningmodel.getDistributionList().stream().filter(dist -> dist.getVariable().isParameterVariable()).map(dist -> {
            Node node = new Node((EF_ConditionalDistribution)dist);
            this.nonReplicatedVarsToNode.put(dist.getVariable(), node);
            return node;
        }).collect(Collectors.toList());
        this.localHiddenNodes = new ArrayList<Node>();
        this.hiddenToNode = new ConcurrentHashMap<Variable, Node>();
        for (Variable localVar : this.localHiddenVars) {
            Node node2 = new Node((EF_ConditionalDistribution)this.ef_learningmodel.getDistribution(localVar));
            this.hiddenToNode.put(localVar, node2);
            this.localHiddenNodes.add(node2);
        }
        for (i = 0; i < this.nReplications; ++i) {
            ConcurrentHashMap map = new ConcurrentHashMap();
            List tmpNodes = this.ef_learningmodel.getDistributionList().stream().filter(dist -> !dist.getVariable().isParameterVariable()).filter(dist -> !this.hiddenToNode.containsKey(dist.getVariable())).map(dist -> {
                Node node = new Node((EF_ConditionalDistribution)dist);
                map.put(dist.getVariable(), node);
                return node;
            }).collect(Collectors.toList());
            this.replicatedVarsToNode.add(map);
            this.replicatedNodes.add(tmpNodes);
        }
        for (i = 0; i < this.nReplications; ++i) {
            for (Node node2 : (List)this.replicatedNodes.get(i)) {
                int slice = i;
                node2.setParents(node2.getPDist().getConditioningVariables().stream().map(var -> this.getNodeOfVar((Variable)var, slice)).collect(Collectors.toList()));
                node2.getPDist().getConditioningVariables().stream().forEach(var -> this.getNodeOfVar((Variable)var, slice).getChildren().add(node2));
            }
        }
        for (Variable localVar : this.localHiddenVars) {
            Node localNode = this.hiddenToNode.get(localVar);
            localNode.setParents(localNode.getPDist().getConditioningVariables().stream().map(var -> this.getNodeOfVar((Variable)var, 0)).collect(Collectors.toList()));
            localNode.getPDist().getConditioningVariables().stream().forEach(var -> this.getNodeOfVar((Variable)var, 0).getChildren().add(localNode));
            if (!this.dynamic) continue;
            localNode.getParents().stream().forEach(node -> node.setActive(false));
        }
        ArrayList<Node> allNodes = new ArrayList<Node>();
        allNodes.addAll(this.nonReplictedNodes);
        allNodes.addAll(this.localHiddenNodes);
        for (int i2 = 0; i2 < this.nReplications; ++i2) {
            allNodes.addAll((Collection)this.replicatedNodes.get(i2));
        }
        this.vmp.setNodes(allNodes);
    }

    @Override
    public <E extends EF_UnivariateDistribution> E getEFParameterPosterior(Variable var) {
        return (E)((Node)this.nonReplicatedVarsToNode.get(var)).getQDist();
    }

    @Override
    public Node getNodeOfVar(Variable variable, int slice) {
        if (variable.isParameterVariable()) {
            return (Node)this.nonReplicatedVarsToNode.get(variable);
        }
        if (this.hiddenToNode.containsKey(variable)) {
            return this.hiddenToNode.get(variable);
        }
        return (Node)((Map)this.replicatedVarsToNode.get(slice)).get(variable);
    }
}

