/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

public interface Vector {
    public double get(int var1);

    public void set(int var1, double var2);

    public int size();

    default public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.get(i);
        }
        return sum;
    }

    default public void sum(Vector vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors do not have same size.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.set(i, this.get(i) + vector.get(i));
        }
    }

    default public void substract(Vector vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors do not have same size.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.set(i, this.get(i) - vector.get(i));
        }
    }

    default public void copy(Vector vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors do not have same size.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.set(i, vector.get(i));
        }
    }

    default public void divideBy(double val) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.get(i) / val);
        }
    }

    default public void multiplyBy(double val) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.get(i) * val);
        }
    }

    default public void sumConstant(double val) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.get(i) + val);
        }
    }

    default public double dotProduct(Vector vector) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors do not have same size.");
        }
        double sum = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            sum += this.get(i) * vector.get(i);
        }
        return sum;
    }

    default public boolean equalsVector(Vector vector, double threshold) {
        if (this.size() != vector.size()) {
            throw new IllegalArgumentException("Vectors do not have same size.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!(Math.abs(this.get(i) - vector.get(i)) > threshold)) continue;
            return false;
        }
        return true;
    }

    public static Vector sumVector(Vector vec1, Vector vec2) {
        vec2.sum(vec1);
        return vec2;
    }

    default public String output() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(this.get(i));
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

