/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.datastream.filereaders;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.filereaders.DataFileReader;
import eu.amidst.core.datastream.filereaders.DataRow;
import eu.amidst.core.datastream.filereaders.DataRowMissing;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.datastream.filereaders.NextDynamicDataInstance;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DynamicDataInstanceSpliterator
implements Spliterator<DynamicDataInstance> {
    private DataFileReader reader;
    private Iterator<DataRow> dataRowIterator;
    private Attribute attSequenceID;
    private Attribute attTimeID;
    private NextDynamicDataInstance nextDynamicDataInstance;
    private final Spliterator<DataRow> spliterator;
    private final int characteristics;
    private long est;
    private int option;

    public DynamicDataInstanceSpliterator(DataFileReader reader_) {
        this.reader = reader_;
        this.dataRowIterator = this.reader.iterator();
        this.spliterator = this.reader.spliterator();
        int c = this.spliterator.characteristics();
        this.characteristics = (c & 0x40) != 0 ? c | 0x4000 : c;
        this.est = this.spliterator.estimateSize();
        DataRowMissing past = new DataRowMissing();
        int timeID = 0;
        int sequenceID = 0;
        if (!this.dataRowIterator.hasNext()) {
            throw new UnsupportedOperationException("There are insufficient instances to learn a model.");
        }
        DataRow present = this.dataRowIterator.next();
        this.attSequenceID = this.reader.getAttributes().getSeq_id();
        if (this.attSequenceID != null) {
            sequenceID = (int)present.getValue(this.attSequenceID);
        }
        this.attTimeID = this.reader.getAttributes().getTime_id();
        if (this.attTimeID != null) {
            timeID = (int)present.getValue(this.attTimeID);
        }
        this.nextDynamicDataInstance = new NextDynamicDataInstance(past, present, sequenceID, timeID);
        this.option = (this.attTimeID == null ? 0 : 1) + 2 * (this.attSequenceID == null ? 0 : 1);
    }

    public static Stream<DynamicDataInstance> toDynamicDataInstanceStream(DataFileReader reader) {
        return StreamSupport.stream(new DynamicDataInstanceSpliterator(reader), false);
    }

    @Override
    public Spliterator<DynamicDataInstance> trySplit() {
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super DynamicDataInstance> action) {
        if (!this.dataRowIterator.hasNext()) {
            return false;
        }
        switch (this.option) {
            case 0: {
                action.accept(this.nextDynamicDataInstance.nextDataInstance_NoTimeID_NoSeq(this.dataRowIterator));
                return true;
            }
            case 1: {
                action.accept(this.nextDynamicDataInstance.nextDataInstance_NoSeq(this.dataRowIterator, this.attTimeID));
                return true;
            }
            case 2: {
                action.accept(this.nextDynamicDataInstance.nextDataInstance_NoTimeID(this.dataRowIterator, this.attSequenceID));
                return true;
            }
            case 3: {
                DynamicDataInstance dynamicDataInstance = this.nextDynamicDataInstance.nextDataInstance(this.dataRowIterator, this.attSequenceID, this.attTimeID);
                if (dynamicDataInstance != null) {
                    action.accept(dynamicDataInstance);
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void forEachRemaining(Consumer<? super DynamicDataInstance> action) {
        while (this.dataRowIterator.hasNext()) {
            this.tryAdvance(action);
        }
    }

    @Override
    public Comparator<DynamicDataInstance> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    static final class HoldingConsumer<T>
    implements Consumer<T> {
        Object value;

        HoldingConsumer() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }
}

