% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randPar.R, R/abcdPar.R, R/bbcdPar.R, R/ebcPar.R, R/bsdPar.R, R/chenPar.R, R/crPar.R, R/gbcdPar.R, R/hadaPar.R, R/mpPar.R, R/pbrPar.R, R/rarPar.R, R/tbdPar.R, R/udPar.R
\docType{methods}
\name{generateAllSequences}
\alias{generateAllSequences}
\alias{getAllSeq}
\alias{getAllSeq,abcdPar-method}
\alias{getAllSeq,bbcdPar-method}
\alias{getAllSeq,bsdPar-method}
\alias{getAllSeq,chenPar-method}
\alias{getAllSeq,crPar-method}
\alias{getAllSeq,ebcPar-method}
\alias{getAllSeq,gbcdPar-method}
\alias{getAllSeq,hadaPar-method}
\alias{getAllSeq,mpPar-method}
\alias{getAllSeq,pbrPar-method}
\alias{getAllSeq,rarPar-method}
\alias{getAllSeq,tbdPar-method}
\alias{getAllSeq,udPar-method}
\title{Complete set of randomization sequences}
\usage{
getAllSeq(obj)

\S4method{getAllSeq}{abcdPar}(obj)

\S4method{getAllSeq}{bbcdPar}(obj)

\S4method{getAllSeq}{ebcPar}(obj)

\S4method{getAllSeq}{bsdPar}(obj)

\S4method{getAllSeq}{chenPar}(obj)

\S4method{getAllSeq}{crPar}(obj)

\S4method{getAllSeq}{gbcdPar}(obj)

\S4method{getAllSeq}{hadaPar}(obj)

\S4method{getAllSeq}{mpPar}(obj)

\S4method{getAllSeq}{pbrPar}(obj)

\S4method{getAllSeq}{rarPar}(obj)

\S4method{getAllSeq}{tbdPar}(obj)

\S4method{getAllSeq}{udPar}(obj)
}
\arguments{
\item{obj}{object specifying the randomization procedure, i.e. an object of a
class.}
}
\value{
An object inheriting from \linkS4class{randSeq}, representing the set 
of randomization sequences for the given parameters.
The output consists of the parameters used for the generation of the 
randomization sequences (see \code{\link{createParam}}) and the matrix \code{M}
that stores the randomization sequences in its rows.
}
\description{
Outputs all randomization sequences for the given randomization procedure 
along with the parameters belonging to the randomization procedure.
The output consists of the parameters used for the generation of the 
randomization sequences (see \code{\link{createParam}}) and the matrix \code{M}
that stores the randomization sequences in its rows.
}
\details{
\code{getAllSeq} is a generic function which dispatches different 
methods depending on the type of input.
}
\examples{
# CR
myPar <- crPar(6)
getAllSeq(myPar)

# EBC
myPar <- ebcPar(6, 0.667)
getAllSeq(myPar)

# BSD
myPar <- bsdPar(6, 2)
getAllSeq(myPar)

# PBR
myPar <- pbrPar(c(4, 2))
getAllSeq(myPar)

# RAR
myPar <- rarPar(8)
getAllSeq(myPar)

# MP 
myPar <- mpPar(8, 2)
getAllSeq(myPar)

# HAD
myPar <- hadaPar(8)
getAllSeq(myPar)

# TBD
myPar <- tbdPar(8)
getAllSeq(myPar)

# GBCD
myPar <- gbcdPar(8, 2)
getAllSeq(myPar)

# ABCD
myPar <- abcdPar(8, 3)
getAllSeq(myPar)

# BBCD
myPar <- bbcdPar(8, 5)
getAllSeq(myPar)

# CHEN
myPar <- chenPar(8, 2, 0.667)
getAllSeq(myPar)

}
\seealso{
\code{\link{createParam}}
}

