% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbcdPar.R
\name{bbcdPar}
\alias{bbcdPar}
\title{Representing Bayesian Biased Coin Design}
\usage{
bbcdPar(N, a, groups = LETTERS[1:2])
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{a}{nonnegative parameter which my be adjusted according to how strongly it is 
desired to balance the experiment. a = 0 gives the complete randomization, while the
assignments become more deterministic as \code{a} increases.}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{bbcdPar}.
}
\description{
Represents the randomization procedure Bayesian Biased Coin Design.
}
\details{
Extension of Efron's biased coin design.
}
\references{
A. B. Antognini and Maroussa Zagoraiou (2014) Balance and randomness in sequential
clinical trials: the dominant biased coin design.
\emph{Pharmaceutical Statistics}
\strong{13(2)}, 119-127
}
\seealso{
Other randomization procedures: \code{\link{abcdPar}},
  \code{\link{bsdPar}}, \code{\link{chenPar}},
  \code{\link{crPar}}, \code{\link{createParam}},
  \code{\link{ebcPar}}, \code{\link{gbcdPar}},
  \code{\link{hadaPar}}, \code{\link{mpPar}},
  \code{\link{pbrPar}}, \code{\link{rarPar}},
  \code{\link{rpbrPar}}, \code{\link{rtbdPar}},
  \code{\link{tbdPar}}, \code{\link{udPar}}
}
