% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess.R
\name{assess}
\alias{assess}
\alias{assess,randSeq,missing-method}
\alias{assess,randSeq,endpoint-method}
\title{Assessing randomization sequences}
\usage{
assess(randSeq, ..., endp)

\S4method{assess}{randSeq,missing}(randSeq, ..., endp)

\S4method{assess}{randSeq,endpoint}(randSeq, ..., endp)
}
\arguments{
\item{randSeq}{object of class \code{randSeq}.}

\item{...}{at least one object of class \code{issue} or just a list of objects
of the class \code{issue}.}

\item{endp}{object of class \code{endpoint}, or \code{missing}.}
}
\value{
\code{S4} object of class \code{assessment} summarizing the assessment of the
randomization procedure.
}
\description{
Assesses randomization sequences based on specified issues
in clinical trials.
}
\details{
Randomization sequences behave differently with respect to issues
like selection bias, chronological bias, or loss in power estimation.
The \code{assess} function evaluates the behavior of randomization
sequences with respect to these issues.
The first argument should be a result of one of the functions
\code{\link{genSeq}} or \code{\link{getAllSeq}}.
The second argument should be any number of \code{\link{issues}} arising
in a clinical trial. The last argument \code{endp} may be provided if
the assessment should take the distribution of the treatment groups
into account, e.g. for power evaluation.
}
\examples{
# assess the full set of Random Allocation Rule for N=4 patients
sequences <- getAllSeq(rarPar(4))
issue1 <- corGuess("CS")
issue2 <- corGuess("DS")
issue3 <- imbal("imb")
issue4 <- imbal("maxImb")
assess(sequences, issue1, issue2, issue3, issue4)

# assess one sequence of the Big Stick Design with respect to correct guesses
sequence <- genSeq(bsdPar(10, 2), seed = 1909)
assess(sequence, issue1)

# assess the same sequence with respect to selection bias and power for a normal endpoint
endp <- normEndp(c(2, 2), c(1, 1))
issue5 <- selBias("CS", 4, "exact")
issue6 <- setPower(2, "exact")
assess(sequence, issue1, issue5, issue6, endp = endp)

# assess the same sequence with respect to selection bias for an exponential endpoint
endp <- expEndp(lambda = c(0.5, 0.5), cenRate=0.1, accrualTime=1, cenTime=5)
issue7 <- selBias("CS", 0.1, "exact")
assess(sequence, issue1, issue7, endp = endp)

# recommended plot for the assessment of rejection probabilities
RP <- getAllSeq(crPar(6))
cB <- chronBias(type = "linT", theta = 1/6, method = "exact")
sB <- selBias(type=  "CS", eta = 1/4, method = "exact")
normEndp <- normEndp(c(0, 0), c(1, 1))
A <- assess(RP, cB, sB, endp = normEndp)
D <- A$D
desiredSeq <- round(sum(D[,2][D[,3] <= 0.05 & D[,4] <= 0.05]), digits = 4)
colnames(D) <- c("Seq", "Prob", "SB", "linT")
g <- ggplot(D, aes(x = SB, y = linT))
g <- g + annotate("rect", xmin = 0, xmax = 0.05, ymin = 0, ymax = 0.05,
alpha=0.2, fill="green") 
g <- g + geom_point(alpha = 1/10, size = 3, col = "orange")
g <- g <- g + geom_vline(xintercept = 0.05, col = "red")
g <- g + geom_hline(yintercept = 0.05, col = "red")
g  <- g + geom_text(data = NULL, x = 0, y = 0,
label = paste("Proportion:", desiredSeq), hjust=0, vjust=0, size = 7)
g

}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

\code{\link{issues}} for the assessment of randomization sequences
}
