% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapPlot-methods.R
\docType{methods}
\name{plot,rmap.frame,missing-method}
\alias{plot,rmap.frame,missing-method}
\title{Plot a rmap.frame}
\usage{
\S4method{plot}{rmap.frame,missing}(x, colours = palette_rangemap("set1"),
  outlierDetector, boundary, boundaryCol = 1, boundarySize = 0.5, ...)
}
\arguments{
\item{x}{a \code{rmap.frame} object.}

\item{colours}{a vector of colours to pass to \code{\link[ggplot2]{scale_fill_gradientn}}.}

\item{outlierDetector}{a function used to detect ouliers. Should return lower and upper limits of non-outliers.}

\item{boundary}{a \code{\link[sp]{Spatial}}* object which can be \code{\link[ggplot2]{fortify}}ed.}

\item{boundaryCol}{boundary color, see \code{\link[ggplot2]{geom_polygon}}.}

\item{boundarySize}{boundary size, \code{\link[ggplot2]{geom_polygon}}.}

\item{\dots}{further arguments to pass to \code{\link[gridExtra]{arrangeGrob}}.}
}
\value{
a \code{ggplot} object for one map or a \code{gtable} in case of more than one map.
}
\description{
Plot a rmap.frame
}
\examples{
require(rangeMapper)
breding_ranges = rgdal::readOGR(system.file(package = "rangeMapper",
     "extdata", "wrens", "vector_combined"), "wrens", verbose = FALSE)[1:70, ]
data(wrens)
d = subset(wrens, select = c('sci_name', 'body_mass', 'clutch_size') )
con = ramp("wrens.sqlite", gridSize = 4, spdf = breding_ranges, biotab = d, ID = "sci_name",
            FUN = "median", overwrite = TRUE)
m = rangeMap.fetch(con, c('median_body_mass', 'median_clutch_size'), spatial = FALSE)
plot(m, ncol = 2)

wrens_boundary = rgeos::gUnionCascaded(breding_ranges)
plot(m, ncol = 2, boundary = wrens_boundary)

\dontrun{
if(require(extremevalues))
plot(m, ncol = 2, outlierDetector = function(x) getOutliersI(x)$limit)
}
}
\seealso{
\code{\link{plot,SpatialPixelsRangeMap,missing-method}}
}
