% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapCanvas-methods.R
\name{gridSize.save}
\alias{gridSize.save}
\alias{gridSize.save,}
\alias{gridSize.fetch}
\title{Save or retrieve the grid size from an \code{rangeMapper} project.}
\usage{
gridSize.save(con, ...)

gridSize.fetch(con)
}
\arguments{
\item{con}{A connection pointing to a valid \code{rangeMapper} project.}

\item{\dots}{\code{gridSize}: A numeric vector of one unit length. See
notes.}
}
\value{
\item{list("gridSize.fetch")}{Returns a numeric vector of one unit
             length containing the grid size previously saved by \code{gridSize.save}}
}
\description{
Save or retrieve the grid size from the active sqlite database.
}
\note{
If \code{gridSize} is not given the default grid size is computed
             based on the bounding box as the range of the smallest axis /100.
}
\examples{
wd = tempdir()
dbcon = rangeMap.start(file = "test.sqlite", overwrite = TRUE, dir = wd )
global.bbox.save(con = dbcon)
gridSize.save(dbcon, gridSize = 2)

dbcon = rangeMap.start(file = "test.sqlite", overwrite = TRUE, dir = wd )
global.bbox.save(con = dbcon)
gridSize.save(dbcon)
gridSize.fetch(dbcon) #default grid size value
}
