% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_maps.R
\name{rmap_save_map}
\alias{rmap_save_map}
\alias{rmap_save_map,rmapConnection,missing,missing,missing,missing,missing-method}
\alias{rmap_save_map,rmapConnection,missing,missing,missing,character,character-method}
\alias{rmap_save_map,rmapConnection,character,character,character,missing,character-method}
\alias{rmap_save_map,rmapConnection,character,character,character,character,character-method}
\alias{rmap_save_map,rmapConnection,function,character,character,missing,character-method}
\alias{rmap_save_map,rmapConnection,function,character,character,character,character-method}
\alias{rmap_save_map,rmapConnection,function,character,ANY,missing,character-method}
\alias{rmap_save_map,rmapConnection,function,character,ANY,character,character-method}
\alias{rmap_save_map,rmapConnection,character,Raster,missing,missing,character-method}
\title{Save maps}
\usage{
rmap_save_map(con, fun, src, v, subset, dst, ...)

\S4method{rmap_save_map}{rmapConnection,missing,missing,missing,missing,missing}(con)

\S4method{rmap_save_map}{rmapConnection,missing,missing,missing,character,character}(con, subset, dst)

\S4method{rmap_save_map}{rmapConnection,character,character,character,missing,character}(con, fun, src, v, dst)

\S4method{rmap_save_map}{rmapConnection,character,character,character,character,character}(con, fun, src, v, subset, dst)

\S4method{rmap_save_map}{rmapConnection,`function`,character,character,missing,character}(con, fun, src, v, subset, dst, ...)

\S4method{rmap_save_map}{rmapConnection,`function`,character,character,character,character}(con, fun, src, v, subset, dst, ...)

\S4method{rmap_save_map}{rmapConnection,`function`,character,ANY,missing,character}(con, fun, src, v, subset, dst, ...)

\S4method{rmap_save_map}{rmapConnection,`function`,character,ANY,character,character}(con, fun, src, v, subset, dst, ...)

\S4method{rmap_save_map}{rmapConnection,character,Raster,missing,missing,character}(con, fun, src, v, subset, dst, ...)
}
\arguments{
\item{con}{a rangeMapper connection made with  \code{\link[=rmap_connect]{rmap_connect()}}.}

\item{fun}{the name of the function to save, either an SQLite or an R function.
see Details.}

\item{src}{the name of the source table previously imported by \code{\link[=rmap_add_bio]{rmap_add_bio()}}.}

\item{v}{the variable to map or a function taking several variables as arguments.
and returning one or several values.}

\item{subset}{the name of a subset table. see \link{rmap_save_subset}.}

\item{dst}{the name of the new map table.}

\item{...}{arguments passed to fun.}
}
\value{
TRUE when a table or a database view is written to the project file, FALSE otherwise.
}
\description{
\code{Maps} are aggregate summaries computed for each canvas cell.
}
\details{
\code{rmap_save_map} makes maps based on data within the project or based on external raster objects.
Aggregate functions can be:
\itemize{
\item internal \code{SQL} aggregate functions: \verb{'avg', 'count', 'max', 'min', 'sum', 'stdev',    'variance', 'mode', 'median', 'lower_quartile', 'upper_quartile', 'group_concat'}.
\item \code{R} functions taking one argument and returning one value.
\item arbitrary statistical models applied on \code{bio} tables.
}
}
\examples{
require(rangeMapper)
require(data.table)
con = rmap_connect()
wrens = read_wrens()
rmap_add_ranges(con, x = wrens, ID = 'sci_name')
rmap_prepare(con, 'hex', cellsize=500)
rmap_save_map(con) # default is a species_richness map.

rmap_add_bio(con, wrens, 'sci_name')
rmap_save_map(con, fun='avg', src='wrens',v='body_mass', dst='avg_bodymass')

rmap_save_subset(con,dst ='ss1', species_richness = 'species_richness > 10')
rmap_save_map(con,subset = 'ss1', dst ='sr2')
rmap_save_map(con, fun='avg', src='wrens',v='body_mass', 
 subset='ss1', dst='avg_bodymass_high_SR')

rmap_save_map(con, fun= mean, na.rm = TRUE, src='wrens',
 v='body_mass', dst='mean_bodymass')

Median = function(x) median(x,na.rm = TRUE)

rmap_save_map(con, fun = Median, src='wrens',
 v='body_mass', dst='median_bodymass')

rmap_save_map(con, fun= mean, na.rm = TRUE, src='wrens',v='body_mass', 
 subset='ss1', dst='mean_bodymass_high_SR')

linmod = function(x) {
  lm(clutch_size ~ log(female_tarsus), x) \%>\% 
  summary \%>\% coefficients \%>\% data.table \%>\% .[-1] }
rmap_save_map(con, fun= linmod, src='wrens', dst='slope_clutch_size')

data(dem)
rmap_save_map(con, fun= 'mean', src= dem ,  dst='dem', progress = FALSE)

x = rmap_to_sf(con)

dbDisconnect(con)

}
