% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autofill.R
\name{rmmAutofillEnvironment}
\alias{rmmAutofillEnvironment}
\title{Add relevant environmental data information to an rmm object}
\usage{
rmmAutofillEnvironment(rmm, env, transfer)
}
\arguments{
\item{rmm}{an rmm list}

\item{env}{a raster stack}

\item{transfer}{0 if not transfer, 1:n for n environments that you're transferring to}
}
\value{
a range model metadata list
}
\description{
This can be used with environmental layers used for fitting or transferring
}
\details{
See Examples.
}
\examples{
\dontrun{
rmm=rmmTemplate()
rasterFiles=list.files(path=paste(system.file(package='dismo'), '/ex', sep=''),
                       pattern='grd', full.names=TRUE)
#make a stack of the rasters
env=raster::stack(rasterFiles)
# for fitting environment
rmm=rmmAutofillEnvironment(rmm,env,transfer=0)
# for the first environment that you're transfering to
rmm=rmmAutofillEnvironment(rmm,env,transfer=1)
# for the second environment that you're transfering to, etc.
rmm=rmmAutofillEnvironment(rmm,env,transfer=2)
}
}
\seealso{
Other autofill: 
\code{\link{rmmAutofillBIEN}()},
\code{\link{rmmAutofillENMeval}()},
\code{\link{rmmAutofillPackageCitation}()},
\code{\link{rmmAutofillspocc}()}
}
\author{
Cory Merow <cory.merow@gmail.com>, Brian Maitner <bmaitner@gmail.com>,
}
\concept{autofill}
