#' Compare intervals
#'
#' Given a data frame representing a set of intervals, return true if row i is
#' less than row j under the order generated by the intervals and false
#' otherwise.
#'
#' @param intervals data frame (see [rankUncertainty::generateIntervals] for
#' the required format)
#' @param i row index of left-hand side of inequality
#' @param j row index of right-hand side of inequaltiy
#'
#' @return Boolean value
#' @export
#'
#' @examples
#' left <- 0:2 * 0.5 + 1
#' right <- left + 0.75
#' intervals <- data.frame(left = left, right = right)
#' lessThan(intervals, 1, 2)
#' lessThan(intervals, 1, 3)
lessThan <- function(intervals, i, j)
{
  errorCheck(intervals, FALSE)

  intervals[i, 'right'] < intervals[j, 'left']
}
