# Author: Robert J. Hijmans
# contact: r.hijmans@gmail.com
# Date : November 2008
# Version 0.9
# Licence GPL v3



if (!isGeneric("readAll")) {
	setGeneric("readAll", function(object)
		standardGeneric("readAll"))
}

	
setMethod('readAll', signature(object='RasterLayer'), 
	function(object){ 
		if (! object@data@fromdisk)  {
			stop('cannot read values; there is no file associated with this RasterLayer')
		}
		object@data@values <- .readRasterLayerValues(object, 1, object@nrows)
		object@data@inmemory <- TRUE
		w <- getOption('warn')
		on.exit(options('warn' = w))
		options('warn'=-1) 
		object@data@min <- as.vector( min(object@data@values, na.rm=TRUE ) )
		object@data@max <- as.vector( max(object@data@values, na.rm=TRUE ) )
		object@data@haveminmax <- TRUE
		return(object)
	}
)


setMethod('readAll', signature(object='RasterStack'), 
	function(object){ 
		for (i in seq(nlayers(object))) {
			if (! object@layers[[i]]@data@inmemory  ) {
				object@layers[[i]] <- readAll(object@layers[[i]])
#				object@layers[[i]]@data@values <- .readRasterLayerValues(object@layers[[i]], 1, object@nrows) 
			}
		}
		return(object)
	}
)


setMethod('readAll', signature(object='RasterBrick'), 
	function(object){ 
		if (! object@data@fromdisk)  {
			stop('cannot read values; there is no file associated with this RasterLayer')
		}
		object@data@inmemory <- TRUE
		object@data@values <- .readRasterBrickValues(object, 1, object@nrows)
		rge <- apply(object@data@values, 2, FUN=function(x){ range(x, na.rm=TRUE) } )
		object@data@min <- as.vector(rge[1,])
		object@data@max <- as.vector(rge[2,])
		object@data@haveminmax <- TRUE
		return(object)
	}
)

