\name{plotRGB}

\docType{methods}

\alias{plotRGB}
\alias{plotRGB,RasterStackBrick-method}

\title{Red-Green-Blue plot of a multi-layered Raster object}

\description{
Make a Red-Green-Blue plot based on three layers (in a RasterBrick or RasterStack). Three layers (bands) are combined such that one is the red channel, one is the green channel, and one is the blue channel. This function could be used to make 'True (or false) color images' from Landsat and other multi-band satellite images. 
}

\section{Methods}{
\describe{

\code{plotRGB(x, r=1, g=2, b=3, scale, maxpixels=500000, stretch=NULL, ext=NULL, ...)}

\tabular{rll}{
\tab \code{x} \tab a RasterBrick or RasterStack object \cr
\tab \code{r}  \tab  Integer. Index of the Red channel, between 1 and nlayers(x) \cr
\tab \code{g}  \tab  Integer. Index of the Green channel, between 1 and nlayers(x) \cr
\tab \code{b}  \tab  Integer. Index of the Blue channel, between 1 and nlayers(x)\cr
\tab \code{scale}  \tab Integer. Maximum (possible) value in the three channels. Defaults to 255 or to the maximum value of \code{x} if that is known and larger than 255 \cr 
\tab \code{maxpixels}  \tab  Maximum number of pixels to use  \cr
\tab \code{stretch}  \tab Option to stretch the values to increase the contrast of the image: "lin" or "hist"\cr
\tab \code{ext}  \tab  An extent object to zoom in a region \cr
\tab \code{...} \tab graphical parameters as in \code{\link{rasterImage}} \cr
}
}}

\author{ Robert J. Hijmans; stretch option based on functions by Josh Gray }

\seealso{ \code{\link[raster]{plot}} }

\examples{
b <- brick(system.file("external/rlogo.grd", package="raster"))
plotRGB(b)
plotRGB(b, 3, 2, 1)
plotRGB(b, 3, 2, 1, stretch='hist')
}

\keyword{methods}
\keyword{spatial}

