% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterpic_img.R
\name{rasterpic_img}
\alias{rasterpic_img}
\title{Convert an image to a geo-tagged raster}
\usage{
rasterpic_img(
  x,
  img,
  halign = 0.5,
  valign = 0.5,
  expand = 0,
  crop = FALSE,
  mask = FALSE,
  inverse = FALSE
)
}
\arguments{
\item{x}{A \code{sf} or \code{sfc} object (\strong{sf} package) or a
\code{SpatRaster} object (\strong{terra} package).}

\item{img}{An image to be geotagged. The following image extensions are
accepted:
\itemize{
\item \code{png}
\item \code{jpeg/jpg}
\item \code{tiff/tif}
}}

\item{halign}{Horizontal alignment of \code{img} with respect to the \code{x} object.
It should be a value between \code{0} (\code{x} is aligned on the left edge of the
raster) and \code{1} (\code{x} is on the right edge of the raster).}

\item{valign}{Vertical alignment of \code{img} with respect to the \code{x} object.
It should be a value between \code{0} (\code{x} is aligned on the bottom edge of the
raster) and \code{1} (\code{x} is on the top edge of the raster).}

\item{expand}{An expansion factor of the bounding box of \code{x}. \code{0} means that
no expansion is added, \code{1} means that the bounding box is expanded to double
the original size.}

\item{crop}{Logical. Should the raster be cropped to the (expanded) bounding
box of \code{x}?}

\item{mask}{Logical. Should the raster be masked to \code{x}? See \code{\link[terra:mask]{terra::mask()}}
for details. This option is only valid if \code{x} is a \code{sf/sfc} object.}

\item{inverse}{Logical. It affects only if \code{mask = TRUE}. If \code{TRUE}, areas on
the raster that do not overlap with \code{x} are masked.}
}
\value{
A \code{SpatRaster} object.
}
\description{
Geotags an image based on the coordinates of a given spatial object.
}
\details{
The function preserves the Coordinate Reference System of the \code{x} object. For
optimal results do not use geographic coordinates (longitude/latitude).
}
\examples{
\donttest{
library(sf)
library(terra)

x_path <- system.file("gpkg/UK.gpkg", package = "rasterpic")
x <- st_read(x_path, quiet = TRUE)
img <- system.file("img/vertical.png", package = "rasterpic")

# Default config
ex1 <- rasterpic_img(x, img)

class(ex1)


plotRGB(ex1)
plot(x$geom,
  add = TRUE,
  col = NA,
  border = "white",
  lwd = 2
)

# Expand
ex2 <- rasterpic_img(x,
  img,
  expand = 0.5
)

plotRGB(ex2)
plot(x$geom,
  add = TRUE,
  col = NA,
  border = "white",
  lwd = 2
)

# Align
ex3 <- rasterpic_img(x,
  img,
  halign = 0
)

plotRGB(ex3)
plot(x$geom,
  add = TRUE,
  col = NA,
  border = "white",
  lwd = 2
)

# Crop
ex4 <- rasterpic_img(x,
  img,
  crop = TRUE
)

plotRGB(ex4)
plot(x$geom,
  add = TRUE,
  col = NA,
  border = "white",
  lwd = 2
)

# Mask
ex5 <- rasterpic_img(x,
  img,
  mask = TRUE
)

plotRGB(ex5)
plot(x$geom,
  add = TRUE,
  col = NA,
  border = "white",
  lwd = 2
)


# Mask inverse
ex6 <- rasterpic_img(x,
  img,
  mask = TRUE,
  inverse = TRUE
)

plotRGB(ex6)
plot(x$geom,
  add = TRUE,
  col = NA,
  border = "white",
  lwd = 2
)


# Combine Mask inverse and crop
ex7 <- rasterpic_img(x,
  img,
  crop = TRUE,
  mask = TRUE,
  inverse = TRUE
)

plotRGB(ex7)
plot(x$geom,
  add = TRUE,
  col = NA,
  border = "white",
  lwd = 2
)
}
}
