% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_hier_dawid_skene_model}
\alias{simulate_hier_dawid_skene_model}
\title{Simulate data from the hierarchical Dawid-Skene model}
\usage{
simulate_hier_dawid_skene_model(pi, mu, sigma, sim_data, seed = NULL)
}
\arguments{
\item{pi}{The pi parameter of the hierarchical Dawid-Skene model.}

\item{mu}{The mu parameter of the hierarchical Dawid-Skene model.}

\item{sigma}{The sigma parameter of the hierarchical Dawid-Skene model.}

\item{sim_data}{Data to guide the simulation. The data must be in the long
data format used in \code{rater()} except without the 'rating' column. The data
specifies:
\itemize{
\item the number of items in the data, and
\item which raters rate each item and how many times they do so.
}}

\item{seed}{An optional random seed to use.}
}
\value{
The passed \code{sim_data} augmented with columns:
\itemize{
\item \code{"z"} containing the latent class of each item,
\item \code{"rating"} containing the simulated rating.
}
}
\description{
Simulate data from the hierarchical Dawid-Skene model
}
\details{
The number of raters implied by the entries in the rater column
must match the number of raters implied by the passed theta parameter.
}
\examples{

\donttest{

J <- 5
K <- 4

pi <- rep(1 / K, K)

mu <- matrix(0, nrow = K, ncol = K)
diag(mu) <- 5

sigma <- matrix(sqrt(2) / sqrt(pi), nrow = K, ncol = K)

sim_data <- data.frame(item = rep(1:2, each = 5), rater = rep(1:5, 2))

sim_result <- simulate_hier_dawid_skene_model(pi, mu, sigma, sim_data)

sim_result$sim
sim_result$theta

}

}
