% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{substituteRatioOfQsprays}
\alias{substituteRatioOfQsprays}
\title{Partial evaluation of a 'ratioOfQsprays' fraction of polynomials}
\usage{
substituteRatioOfQsprays(roq, values)
}
\arguments{
\item{roq}{a \code{ratioOfQsprays} object}

\item{values}{the values to be substituted; this must be a vector whose
length equals the number of variables of \code{roq}, and whose each
entry is either \code{NA} for non-substitution or a "scalar" \code{x}
such that \code{as.character(x)} is a quoted integer or a quoted fraction,
e.g. a \code{bigq} number}
}
\value{
A \code{ratioOfQsprays} object.
}
\description{
Substitute some values to a subset of the variables of a
  \code{ratioOfQsprays} fraction of polynomials.
}
\examples{
library(ratioOfQsprays)
x <- qlone(1)
y <- qlone(2)
z <- qlone(3)
roq <- (x^2 + y^2 + x*y*z - 1) / (x + 1)
substituteRatioOfQsprays(roq, c("2", NA, "3/2"))
}
